/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java;

import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;

public class CoverageAnnotation
extends Annotation {
    private WeakReference<FullElementInfo> info;
    private Position position;

    private CoverageAnnotation(Kind kind, FullElementInfo info, Set<TestCaseInfo> hits, int offset, int length, boolean filtered) {
        super(kind.getId(), false, CoverageAnnotation.textForCoverage(info, kind, hits));
        this.info = new WeakReference<FullElementInfo>(info);
        this.position = new Position(offset, length);
    }

    public static String textForCoverage(ElementInfo info, Kind kind, Set<TestCaseInfo> hits) {
        if (kind != Kind.FILTERED) {
            String message;
            if (info instanceof BranchInfo) {
                BranchInfo branchInfo = (BranchInfo)info;
                message = CoverageAnnotation.linePrefix(info) + "Expression evaluated to true " + branchInfo.getTrueHitCount() + " time" + (branchInfo.getTrueHitCount() == 1 ? "" : "s") + ", false " + branchInfo.getFalseHitCount() + " time" + (branchInfo.getFalseHitCount() == 1 ? "" : "s") + ".";
            } else {
                message = info instanceof StatementInfo ? CoverageAnnotation.linePrefix(info) + "Statement executed " + info.getHitCount() + " time" + (info.getHitCount() == 1 ? "" : "s") + "." : (info instanceof MethodInfo ? CoverageAnnotation.linePrefix(info) + (((MethodInfo)info).isTest() ? "Test method" : "Method") + " executed " + info.getHitCount() + " time" + (info.getHitCount() == 1 ? "" : "s") + "." : "");
            }
            String qualifier = kind.getQualifier();
            return qualifier.length() == 0 ? message : message + "\n" + qualifier;
        }
        return CoverageAnnotation.linePrefix(info) + "Excluded due to filter settings.";
    }

    private static String linePrefix(ElementInfo info) {
        int start = info.getStartLine();
        int end = info.getEndLine();
        return end - start > 0 ? "Lines " + info.getStartLine() + "-" + info.getEndLine() + ": " : "Line " + info.getStartLine() + ": ";
    }

    public Position getPosition() {
        return this.position;
    }

    public boolean encloses(int offset) {
        return this.position.offset <= offset && offset - this.position.offset <= this.position.length;
    }

    public void reposition(int newOffset, int newLength) {
        this.position = new Position(newOffset, newLength);
    }

    public FullElementInfo getInfo() {
        return (FullElementInfo)this.info.get();
    }

    public static enum Kind {
        NOT_COVERED("org.openclover.eclipse.core.coverageannotation.notcovered"),
        COVERED("org.openclover.eclipse.core.coverageannotation.covered"),
        FAILED("org.openclover.eclipse.core.coverageannotation.failed", "(This coverage was generated by one or more tests which failed or had errors)"),
        FILTERED("org.openclover.eclipse.core.coverageannotation.filtered"),
        INCIDENTAL("org.openclover.eclipse.core.coverageannotation.incidental", "(This coverage was not directly generated by test methods)"),
        PARTIAL_BRANCH("org.openclover.eclipse.core.coverageannotation.partialbranch", ""),
        TEST_PASSED_COVERED("org.openclover.eclipse.core.coverageannotation.covered.testpassed", ""),
        TEST_FAILED_COVERED("org.openclover.eclipse.core.coverageannotation.covered.testfailed", "");

        private final String id;
        private final String qualifier;

        private Kind(String id, String qualifier) {
            this.id = id;
            this.qualifier = qualifier;
        }

        private Kind(String id) {
            this(id, "");
        }

        public String getId() {
            return this.id;
        }

        public static Kind kindFor(boolean filtered, ElementInfo element, Set<TestCaseInfo> tcis) {
            if (filtered) {
                return FILTERED;
            }
            if (Kind.hasCoverage(element)) {
                BranchInfo branch;
                if (element instanceof BranchInfo && (branch = (BranchInfo)element).getFalseHitCount() > 0 ^ branch.getTrueHitCount() > 0) {
                    return PARTIAL_BRANCH;
                }
                if (tcis.isEmpty()) {
                    return INCIDENTAL;
                }
                if (Kind.allTestsFail(tcis)) {
                    return FAILED;
                }
                return COVERED;
            }
            return NOT_COVERED;
        }

        private static boolean allTestsFail(Set<TestCaseInfo> tcis) {
            for (TestCaseInfo tci : tcis) {
                if (!tci.isSuccess()) continue;
                return false;
            }
            return true;
        }

        private static boolean hasCoverage(ElementInfo info) {
            if (info instanceof BranchInfo) {
                return ((BranchInfo)info).getTrueHitCount() > 0 || ((BranchInfo)info).getFalseHitCount() > 0;
            }
            return info.getHitCount() > 0;
        }

        public CoverageAnnotation newAnnotation(FullElementInfo info, Set<TestCaseInfo> hits, int offset, int length, boolean filtered) {
            return new CoverageAnnotation(this, info, hits, offset, length, filtered);
        }

        public String getQualifier() {
            return this.qualifier;
        }
    }
}

