/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.cloud;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.editors.CloverProjectInput;
import org.openclover.eclipse.core.ui.editors.cloud.CloudEditor;
import org.openclover.eclipse.core.ui.editors.cloud.RefreshCloudEditorGenerateCloudJob;

public class CloudEditorContributor
extends MultiPageEditorActionBarContributor {
    private CloudEditor cloudEditor;
    private Action refreshAction;

    public CloudEditorContributor() {
        this.createActions();
    }

    public void setActiveEditor(IEditorPart part) {
        if (part instanceof CloudEditor) {
            this.cloudEditor = (CloudEditor)part;
        }
        super.setActiveEditor(part);
    }

    public void setActivePage(IEditorPart part) {
    }

    private void createActions() {
        this.refreshAction = new Action(){

            public void run() {
                CloverProjectInput input;
                CloverProjectInput cloverProjectInput = input = CloudEditorContributor.this.cloudEditor == null ? null : (CloverProjectInput)CloudEditorContributor.this.cloudEditor.getEditorInput();
                if (input != null) {
                    new RefreshCloudEditorGenerateCloudJob(CloudEditorContributor.this.cloudEditor, input.getProject().getProject()).schedule();
                }
            }
        };
        this.refreshAction.setText(CloverEclipsePluginMessages.REFRESH_CLOUD());
        this.refreshAction.setToolTipText(CloverEclipsePluginMessages.REFRESH_CLOUD_TOOL_TIP());
        this.refreshAction.setImageDescriptor(CloverPlugin.getImageDescriptor("icons/clcl16/project_refresh.gif"));
    }

    public void contributeToMenu(IMenuManager manager) {
        IMenuManager menu = manager.findMenuUsingPath("project");
        manager.appendToGroup("additions", (IContributionItem)menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.refreshAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }
}

