/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import com.atlassian.clover.reporters.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jdt.internal.debug.ui.StorageEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.reports.model.ReportHistoryEntry;
import org.openclover.util.Lists;

public abstract class OpenReportOperation {
    public static OpenReportOperation OPEN_PDF;
    public static OpenReportOperation OPEN_XML_WITH_SYSTEM_EDITOR;
    public static OpenReportOperation OPEN_HTML_WITH_SYSTEM_BROWSER;
    public static OpenReportOperation OPEN_HTML_WITH_ECLIPSE_BROWSER;
    private static final OpenReportOperation[] OPERATIONS;

    private static IEditorRegistry getEditorRegistryFromWorkbench() {
        try {
            Class<?> workbenchClass = Class.forName("org.eclipse.ui.internal.Workbench");
            Object workbenchInstance = workbenchClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object editorRegistry = workbenchClass.getMethod("getEditorRegistry", new Class[0]).invoke(workbenchInstance, new Object[0]);
            return (IEditorRegistry)editorRegistry;
        }
        catch (Exception e) {
            CloverPlugin.logError("Failed to retrieve editor registry", e);
            return null;
        }
    }

    private static IEditorDescriptor[] xmlEditorsFor(ReportHistoryEntry report) {
        return OpenReportOperation.getEditorRegistryFromWorkbench().getEditors(report.getPath(), Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml"));
    }

    public static List findFor(ReportHistoryEntry entry) {
        LinkedList supportedMethods = Lists.newLinkedList();
        for (OpenReportOperation reportOperation : OPERATIONS) {
            if (!reportOperation.supports(entry)) continue;
            supportedMethods.add(reportOperation);
        }
        return supportedMethods;
    }

    public abstract String getName();

    public abstract boolean supports(ReportHistoryEntry var1);

    public abstract void open(ReportHistoryEntry var1);

    protected IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    protected IEditorInput inputFor(String path) {
        return new MyEditorInput(new File(path));
    }

    static {
        IEditorDescriptor[] xmlEditors;
        OPEN_PDF = new OpenReportWithSystemEditor(){

            @Override
            public String getName() {
                return CloverEclipsePluginMessages.SYSTEM_PDF_VIEWER();
            }

            @Override
            public boolean supports(ReportHistoryEntry report) {
                return report.getType() == Type.PDF;
            }
        };
        OPEN_XML_WITH_SYSTEM_EDITOR = new OpenReportWithSystemEditor(){

            @Override
            public String getName() {
                return CloverEclipsePluginMessages.SYSTEM_XML_VIEWER();
            }

            @Override
            public boolean supports(ReportHistoryEntry report) {
                return report.getType() == Type.XML;
            }
        };
        OPEN_HTML_WITH_SYSTEM_BROWSER = new OpenReportOperation(){

            @Override
            public String getName() {
                return CloverEclipsePluginMessages.SYSTEM_BROWSER();
            }

            @Override
            public boolean supports(ReportHistoryEntry report) {
                return report.getType() == Type.HTML && PlatformUI.getWorkbench().getBrowserSupport().isInternalWebBrowserAvailable();
            }

            @Override
            public void open(ReportHistoryEntry entry) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    if (browser != null) {
                        browser.openURL(new File(entry.getPath()).toURI().toURL());
                    } else {
                        CloverPlugin.logWarning("No system HTML browser");
                    }
                }
                catch (Exception e) {
                    CloverPlugin.logError("Unable to launch system HTML browser", e);
                }
            }
        };
        OPEN_HTML_WITH_ECLIPSE_BROWSER = new OpenReportOperation(){

            @Override
            public String getName() {
                return CloverEclipsePluginMessages.ECLIPSE_BROWSER();
            }

            @Override
            public boolean supports(ReportHistoryEntry report) {
                return report.getType() == Type.HTML;
            }

            @Override
            public void open(ReportHistoryEntry entry) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser("Clover HTML Report Browser");
                    if (browser != null) {
                        browser.openURL(new File(entry.getPath()).toURI().toURL());
                    } else {
                        CloverPlugin.logWarning("No Eclipse HTML browser");
                    }
                }
                catch (Exception e) {
                    CloverPlugin.logError("Unable to open Eclipse HTML browser", e);
                }
            }
        };
        ArrayList<OpenReportOperation> operations = Lists.newArrayList(OPEN_PDF, OPEN_XML_WITH_SYSTEM_EDITOR, OPEN_HTML_WITH_SYSTEM_BROWSER, OPEN_HTML_WITH_ECLIPSE_BROWSER);
        for (IEditorDescriptor xmlEditor : xmlEditors = OpenReportOperation.getEditorRegistryFromWorkbench().getEditors("foobar.xml", Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml"))) {
            if (!xmlEditor.isInternal()) continue;
            operations.add(new OpenWithEditor(xmlEditor.getId(), Type.XML, xmlEditor.getLabel()));
        }
        OPERATIONS = operations.toArray(new OpenReportOperation[operations.size()]);
    }

    private static class MyEditorInput
    extends StorageEditorInput
    implements IPathEditorInput {
        private final File file;

        public MyEditorInput(File file) {
            super((IStorage)new LocalFileStorage(file));
            this.file = file;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public IPath getPath() {
            return new Path(this.file.getPath());
        }
    }

    public static class OpenWithEditor
    extends OpenReportOperation {
        private String editorId;
        private Type type;
        private final String name;

        protected OpenWithEditor(String editorId, Type type, String name) {
            this.editorId = editorId;
            this.type = type;
            this.name = name;
        }

        @Override
        public String getName() {
            return CloverEclipsePluginMessages.ECLIPSE_VIEWER(this.name);
        }

        @Override
        public boolean supports(ReportHistoryEntry report) {
            return this.type == report.getType();
        }

        @Override
        public void open(ReportHistoryEntry entry) {
            try {
                IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IEditorInput)this.inputFor(entry.getPath()), (String)this.editorId);
            }
            catch (Exception e) {
                CloverPlugin.logError("Unable to launch Eclipse editor " + this.editorId, e);
            }
        }
    }

    public static abstract class OpenReportWithSystemEditor
    extends OpenReportOperation {
        @Override
        public void open(ReportHistoryEntry entry) {
            try {
                IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IEditorInput)this.inputFor(entry.getPath()), (String)"org.eclipse.ui.systemExternalEditor");
            }
            catch (Exception e) {
                CloverPlugin.logError("Unable to launch system reader for " + entry.getPath(), e);
            }
        }
    }
}

