/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.reports.OpenReportOperation;
import org.openclover.eclipse.core.reports.model.ReportHistoryEntry;

public class OpenReportDialog
extends MessageDialog {
    private final List<OpenReportOperation> reportOpenMethods;
    private OpenReportOperation selectedOpenMethod;
    private Combo openActionCombo;

    public OpenReportDialog(Shell parentShell, String reportTitle, List<OpenReportOperation> reportOpenMethods, String openMessage, String[] buttons) {
        super(parentShell, CloverEclipsePluginMessages.REPORT_MESSAGEBOX_TITLE(reportTitle), null, openMessage, 2, buttons, 0);
        this.reportOpenMethods = reportOpenMethods;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        new Label(parent, 0);
        Composite customArea = new Composite(parent, 0);
        customArea.setLayout((Layout)new GridLayout(2, false));
        this.openActionCombo = new Combo(customArea, 8);
        for (OpenReportOperation method : this.reportOpenMethods) {
            this.openActionCombo.add(method.getName());
        }
        this.openActionCombo.select(0);
        return customArea;
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            this.selectedOpenMethod = this.reportOpenMethods.get(this.openActionCombo.getSelectionIndex());
        }
        return super.close();
    }

    public OpenReportOperation getSelectedOpenMethod() {
        return this.selectedOpenMethod;
    }

    public static OpenReportOperation openOnRevist(Shell shell, ReportHistoryEntry entry, List<OpenReportOperation> reportOpenMethods) {
        OpenReportDialog dialog = new OpenReportDialog(shell, entry.getName(), reportOpenMethods, CloverEclipsePluginMessages.REPORT_OPEN_IN(), new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
        dialog.open();
        return dialog.getSelectedOpenMethod();
    }

    public static OpenReportOperation openOnGenerate(Shell shell, ReportHistoryEntry entry, List<OpenReportOperation> reportOpenMethods) {
        OpenReportDialog dialog = new OpenReportDialog(shell, entry.getName(), reportOpenMethods, CloverEclipsePluginMessages.REPORT_SUCCESS_MESSAGE(), new String[]{"Open", IDialogConstants.CANCEL_LABEL});
        dialog.open();
        return dialog.getSelectedOpenMethod();
    }
}

