/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import com.atlassian.clover.reporters.CloverReporter;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlReporter;
import com.atlassian.clover.reporters.pdf.PDFReporter;
import com.atlassian.clover.reporters.xml.XMLReporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.reports.ForkingReportJob;
import org.openclover.eclipse.core.reports.ForkingReporter;

public class FilteredReportJob
extends ForkingReportJob {
    private final CloverProject cloverProject;

    public FilteredReportJob(CloverProject cloverProject, Current reportConfig, String vmArgs, String mxSetting) {
        super(reportConfig, vmArgs, mxSetting);
        this.cloverProject = cloverProject;
    }

    @Override
    protected IStatus runReporter(IProgressMonitor monitor) throws Exception {
        CloverReporter.buildReporter(this.config).execute();
        return Status.OK_STATUS;
    }

    protected String calculateInitString() {
        return this.config.getInitString();
    }

    @Override
    protected String calculateReporterClass() {
        switch (this.config.getFormat().getType()) {
            case HTML: {
                return FilteredHtmlReporter.class.getName();
            }
            case PDF: {
                return FilteredPDFReporter.class.getName();
            }
        }
        return FilteredXMLReporter.class.getName();
    }

    @Override
    protected String calcTestFilterArgs() {
        return this.calcTestFilterArgs(this.cloverProject);
    }

    public static class FilteredPDFReporter
    extends ForkingReporter {
        @Override
        protected int run(String[] args) {
            return PDFReporter.runReport(args);
        }
    }

    public static class FilteredXMLReporter
    extends ForkingReporter {
        @Override
        protected int run(String[] args) {
            return XMLReporter.runReport(args);
        }
    }

    public static class FilteredHtmlReporter
    extends ForkingReporter {
        @Override
        protected int run(String[] args) {
            return HtmlReporter.runReport(args);
        }
    }
}

