/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.reports.ConfigureReportPage;
import org.openclover.eclipse.core.reports.GenerateReportWizard;
import org.openclover.eclipse.core.ui.SwtUtils;

public class ConfigureXmlPage
extends ConfigureReportPage {
    private Button lineInfoButton = null;

    public ConfigureXmlPage() {
        super("ConfigureXML");
        this.setTitle("XML Report Configuration");
        this.setDescription("Fine tune the available coverage report options.");
    }

    @Override
    protected String getOutputPathLabelTitle() {
        return "Output File:";
    }

    @Override
    protected String getDefaultOutputPathFor(IProject project) {
        return project.getProject().getFolder("report").getFile("coverage.xml").getLocation().toFile().getAbsolutePath();
    }

    @Override
    protected Listener newOutputPathListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                String result;
                Shell shell = ((GenerateReportWizard)ConfigureXmlPage.this.getWizard()).workbench.getActiveWorkbenchWindow().getShell();
                FileDialog chooser = new FileDialog(shell, 32768);
                chooser.setText("Choose a file");
                File enclosingDir = ConfigureXmlPage.this.getOutput().getParentFile();
                if (enclosingDir != null) {
                    chooser.setFilterPath(enclosingDir.getAbsolutePath());
                }
                if ((result = chooser.open()) != null) {
                    ConfigureXmlPage.this.setOutputPath(result);
                }
            }
        };
    }

    @Override
    protected void createCustomSettings(Composite composite) {
        this.lineInfoButton = new Button(composite, 32);
        this.lineInfoButton.setText("Include line coverage information in the report");
        this.lineInfoButton.setSelection(true);
        GridData gd = SwtUtils.gridDataFor((Control)this.lineInfoButton);
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 1;
        this.createShowLambdaComposite(composite);
    }

    @Override
    protected void addListeners() {
        Listener listener = this.newValidationListener();
        this.outputPath.addListener(2, listener);
        this.fileButton.addListener(13, listener);
        this.threadCount.addListener(13, listener);
    }

    @Override
    protected File getOutput() {
        return new File(this.outputPath.getText());
    }

    public boolean isIncludingLineInfo() {
        return this.lineInfoButton.getSelection();
    }
}

