/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.reports.ConfigureReportPage;
import org.openclover.eclipse.core.reports.GenerateReportWizard;

public class ConfigurePdfPage
extends ConfigureReportPage {
    public ConfigurePdfPage() {
        super("ConfigurePDF");
        this.setTitle("PDF Report Configuration");
        this.setDescription("Fine tune the available coverage report options.");
    }

    @Override
    protected String getDefaultOutputPathFor(IProject project) {
        return project.getFolder("report").getFile("coverage.pdf").getLocation().toFile().getAbsolutePath();
    }

    @Override
    protected void createCustomSettings(Composite composite) {
    }

    @Override
    protected Listener newOutputPathListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                String result;
                Shell shell = ((GenerateReportWizard)ConfigurePdfPage.this.getWizard()).workbench.getActiveWorkbenchWindow().getShell();
                FileDialog chooser = new FileDialog(shell, 32768);
                chooser.setText("Choose a file");
                File enclosingDir = ConfigurePdfPage.this.getOutput().getParentFile();
                if (enclosingDir != null) {
                    chooser.setFilterPath(enclosingDir.getAbsolutePath());
                }
                if ((result = chooser.open()) != null) {
                    ConfigurePdfPage.this.setOutputPath(result);
                }
            }
        };
    }

    @Override
    protected String getOutputPathLabelTitle() {
        return "Output File:";
    }

    @Override
    protected void addListeners() {
        Listener listener = this.newValidationListener();
        this.outputPath.addListener(2, listener);
        this.fileButton.addListener(13, listener);
        this.threadCount.addListener(13, listener);
    }

    @Override
    protected File getOutput() {
        return new File(this.outputPath.getText());
    }
}

