/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.LayoutUtils;
import org.openclover.eclipse.core.projects.settings.source.SourceRootWithPattern;
import org.openclover.eclipse.core.projects.settings.source.SourceRootsWithPatternTreeContentProvider;
import org.openclover.eclipse.core.projects.settings.source.test.TestFolderLabelProvider;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.util.Sets;

public class TestSourceFilteringComposite
extends Composite {
    private final Button testFoldersAllButton;
    private final Button testFoldersSelectedButton;
    private final Button testFoldersNoneButton;
    private final Text testIncludeFilterText;
    private final Text testExcludeFilterText;
    private final CheckboxTableViewer testRootFolders;
    int lastTestSourceFolders;
    String lastInclude;
    String lastExclude;
    List<String> lastSelectedFolders;

    public TestSourceFilteringComposite(Composite parent, IJavaProject project, ProjectSettings properties, SourceRootsWithPatternTreeContentProvider contentProvider) {
        super(parent, 0);
        this.lastTestSourceFolders = properties.getTestSourceFolders();
        this.lastInclude = properties.getTestIncludeFilter() == null ? "**/*Test.java,**/Test*.java" : properties.getTestIncludeFilter();
        this.lastExclude = properties.getTestExcludeFilter() == null ? "" : properties.getTestExcludeFilter();
        this.lastSelectedFolders = properties.getSelectedTestFolders();
        Group testSourcesGroup = LayoutUtils.createGroup(this, CloverEclipsePluginMessages.TEST_FOLDERS());
        testSourcesGroup.setLayout((Layout)new GLH().standardiseMargin().getGridLayout());
        GridData gridData = new GridData(768);
        testSourcesGroup.setLayoutData((Object)gridData);
        this.testFoldersAllButton = new Button((Composite)testSourcesGroup, 16);
        this.testFoldersAllButton.setText(CloverEclipsePluginMessages.TEST_FOLDERS_ALL());
        this.testFoldersAllButton.setSelection(this.lastTestSourceFolders == 0);
        Composite c = new Composite((Composite)testSourcesGroup, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        GridData gd1 = new GridData(768);
        gd1.horizontalIndent = 30;
        c.setLayoutData((Object)gd1);
        final Label includeLabel = new Label(c, 0);
        includeLabel.setText(CloverEclipsePluginMessages.FILE_FILTERING_INCLUDE());
        this.testIncludeFilterText = new Text(c, 2048);
        this.testIncludeFilterText.setText(this.lastInclude);
        this.testIncludeFilterText.setLayoutData((Object)new GridData(768));
        final Label excludeLabel = new Label(c, 0);
        excludeLabel.setText(CloverEclipsePluginMessages.FILE_FILTERING_EXCLUDE());
        this.testExcludeFilterText = new Text(c, 2048);
        this.testExcludeFilterText.setText(this.lastExclude);
        this.testExcludeFilterText.setLayoutData((Object)new GridData(768));
        this.testFoldersSelectedButton = new Button((Composite)testSourcesGroup, 16);
        this.testFoldersSelectedButton.setText(CloverEclipsePluginMessages.TEST_FOLDERS_SELECTED());
        this.testFoldersSelectedButton.setSelection(this.lastTestSourceFolders == 1);
        this.testRootFolders = CheckboxTableViewer.newCheckList((Composite)testSourcesGroup, (int)2560);
        GridData gd = SwtUtils.gridDataFor(this.testRootFolders.getControl());
        gd.minimumHeight = 100;
        gd.minimumWidth = 250;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 30;
        TestFolderLabelProvider labelProvider = new TestFolderLabelProvider(properties.isInstrumentSelectedSourceFolders());
        this.testRootFolders.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.testRootFolders.setContentProvider((IContentProvider)contentProvider);
        this.testRootFolders.setInput((Object)contentProvider.getProject());
        HashSet<String> selectedFolders = Sets.newHashSet(this.lastSelectedFolders);
        for (SourceRootWithPattern srwp : contentProvider.getChildren(project)) {
            if (!selectedFolders.contains(srwp.getPattern().getSrcPath())) continue;
            this.testRootFolders.setChecked((Object)srwp, true);
        }
        contentProvider.addChangeListener(labelProvider);
        this.testFoldersNoneButton = new Button((Composite)testSourcesGroup, 16);
        this.testFoldersNoneButton.setText(CloverEclipsePluginMessages.TEST_FOLDERS_NONE());
        this.testFoldersNoneButton.setSelection(this.lastTestSourceFolders == 2);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enableAllPart = TestSourceFilteringComposite.this.testFoldersAllButton.getSelection();
                includeLabel.setEnabled(enableAllPart);
                excludeLabel.setEnabled(enableAllPart);
                TestSourceFilteringComposite.this.testIncludeFilterText.setEnabled(enableAllPart);
                TestSourceFilteringComposite.this.testExcludeFilterText.setEnabled(enableAllPart);
                TestSourceFilteringComposite.this.testRootFolders.getControl().setEnabled(TestSourceFilteringComposite.this.testFoldersSelectedButton.getSelection());
            }
        };
        this.testFoldersSelectedButton.addSelectionListener((SelectionListener)adapter);
        this.testFoldersAllButton.addSelectionListener((SelectionListener)adapter);
        adapter.widgetSelected(null);
    }

    public void storeTo(ProjectSettings properties) throws JavaModelException {
        this.lastTestSourceFolders = this.getCurrentTestSourceFolders();
        this.lastInclude = this.testIncludeFilterText.getText().trim();
        this.lastExclude = this.testExcludeFilterText.getText().trim();
        this.lastSelectedFolders = this.getCurrentSelectedTestFolders();
        properties.setTestIncludeFilter(this.lastInclude.length() > 0 ? this.lastInclude : null);
        properties.setTestExcludeFilter(this.lastExclude.length() > 0 ? this.lastExclude : null);
        properties.setTestSourceFolders(this.lastTestSourceFolders);
        properties.setSelectedTestFolders(this.lastSelectedFolders);
    }

    private List<String> getCurrentSelectedTestFolders() throws JavaModelException {
        Object[] selection = this.testRootFolders.getCheckedElements();
        ArrayList<String> selectedFolders = new ArrayList<String>(selection.length);
        for (Object aSelection : selection) {
            selectedFolders.add(((SourceRootWithPattern)aSelection).getPattern().getSrcPath());
        }
        return selectedFolders;
    }

    private int getCurrentTestSourceFolders() {
        return this.testFoldersNoneButton.getSelection() ? 2 : (this.testFoldersSelectedButton.getSelection() ? 1 : 0);
    }

    public boolean isModified() throws JavaModelException {
        if (this.lastTestSourceFolders != this.getCurrentTestSourceFolders()) {
            return true;
        }
        switch (this.lastTestSourceFolders) {
            case 0: {
                return !this.lastInclude.equals(this.testIncludeFilterText.getText().trim()) || !this.lastExclude.equals(this.testExcludeFilterText.getText().trim());
            }
            case 1: {
                return !this.lastSelectedFolders.equals(this.getCurrentSelectedTestFolders());
            }
        }
        return false;
    }
}

