/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source.test;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.settings.source.InstrumentedSourceFoldersListener;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;
import org.openclover.eclipse.core.projects.settings.source.SourceRootWithPattern;

public class TestFolderLabelProvider
extends EventManager
implements ILabelProvider,
IColorProvider,
InstrumentedSourceFoldersListener {
    private final ImageRegistry imageRegistry;
    private boolean perFolderSelectionEnabled;
    private static final String INSTRUMENTED_ICON = "instrumented";
    private static final String NOT_INSTRUMENTED_ICON = "notinstrumented";

    public TestFolderLabelProvider(boolean perFolderSelectionEnabled) {
        this.perFolderSelectionEnabled = perFolderSelectionEnabled;
        this.imageRegistry = new ImageRegistry();
        final ImageDescriptor instrumentedFolder = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/packagefolder_obj.gif");
        if (instrumentedFolder != null) {
            this.imageRegistry.put(INSTRUMENTED_ICON, instrumentedFolder);
            final ImageDescriptor notInstrumentedFolderOverlay = CloverPlugin.getImageDescriptor("icons/ovr16/clovered_nocompile.gif");
            if (notInstrumentedFolderOverlay != null) {
                this.imageRegistry.put(NOT_INSTRUMENTED_ICON, (ImageDescriptor)new CompositeImageDescriptor(){

                    protected void drawCompositeImage(int width, int height) {
                        this.drawImage(instrumentedFolder.getImageData(), 0, 0);
                        this.drawImage(notInstrumentedFolderOverlay.getImageData(), 0, 0);
                    }

                    protected Point getSize() {
                        ImageData imgData = instrumentedFolder.getImageData();
                        return new Point(imgData.width, imgData.height);
                    }
                });
            }
        }
    }

    public void dispose() {
        this.clearListeners();
        this.imageRegistry.dispose();
    }

    public Image getImage(Object element) {
        SourceFolderPattern sfp = ((SourceRootWithPattern)element).getPattern();
        boolean disabled = this.perFolderSelectionEnabled && !sfp.isEnabled();
        return this.imageRegistry.get(disabled ? NOT_INSTRUMENTED_ICON : INSTRUMENTED_ICON);
    }

    public String getText(Object element) {
        SourceFolderPattern sfp = ((SourceRootWithPattern)element).getPattern();
        return sfp.getSrcPath();
    }

    @Override
    public void selectionChanged(SourceRootWithPattern pattern) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)pattern));
    }

    @Override
    public void perFolderSelectionEnabled(boolean enabled) {
        this.perFolderSelectionEnabled = enabled;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    public Color getForeground(Object element) {
        SourceFolderPattern sfp = ((SourceRootWithPattern)element).getPattern();
        boolean disabled = this.perFolderSelectionEnabled && !sfp.isEnabled();
        return disabled ? Display.getCurrent().getSystemColor(33) : null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        this.addListenerObject(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.removeListenerObject(listener);
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        for (Object listener : this.getListeners()) {
            final ILabelProviderListener labelProviderListener = (ILabelProviderListener)listener;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    labelProviderListener.labelProviderChanged(event);
                }
            });
        }
    }
}

