/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.settings.source.InstrumentedSourceFoldersListener;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;
import org.openclover.eclipse.core.projects.settings.source.SourceRootWithPattern;
import org.openclover.util.Lists;

public class SourceRootsWithPatternTreeContentProvider
implements ITreeContentProvider {
    private final IJavaProject project;
    private final SourceRootWithPattern[] children;
    private final List<InstrumentedSourceFoldersListener> listeners = Lists.newArrayList();

    public SourceRootsWithPatternTreeContentProvider(IJavaProject project, Collection<SourceFolderPattern> existing) {
        HashMap<String, SourceFolderPattern> index = new HashMap<String, SourceFolderPattern>(existing.size());
        for (SourceFolderPattern sfp : existing) {
            index.put(sfp.getSrcPath(), sfp);
        }
        ArrayList list = Lists.newArrayList();
        try {
            IPackageFragmentRoot[] pfRoots;
            for (IPackageFragmentRoot pfRoot : pfRoots = project.getPackageFragmentRoots()) {
                try {
                    if (pfRoot.getKind() != 1) continue;
                    String path = pfRoot.getCorrespondingResource().getProjectRelativePath().toString();
                    SourceFolderPattern sfp = (SourceFolderPattern)index.get(path);
                    if (sfp == null) {
                        sfp = new SourceFolderPattern(path, "**/*.java", "", false);
                    }
                    list.add(new SourceRootWithPattern(pfRoot, sfp));
                }
                catch (JavaModelException e) {
                    CloverPlugin.logError("Unable to process package fragment [" + pfRoot.getElementName() + "], skipping.", e);
                }
            }
        }
        catch (JavaModelException e) {
            CloverPlugin.logError("Unable to retrieve package fragment roots.", e);
        }
        this.children = list.toArray(new SourceRootWithPattern[list.size()]);
        this.project = project;
    }

    public SourceRootWithPattern[] getChildren(Object parentElement) {
        if (parentElement == this.project) {
            return this.children;
        }
        return new SourceRootWithPattern[0];
    }

    public Object getParent(Object element) {
        return element == this.project ? null : this.project;
    }

    public boolean hasChildren(Object element) {
        return element == this.project;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public SourceRootWithPattern[] getAllElements() {
        return this.children;
    }

    public SourceRootWithPattern[] getEnabledElements() {
        ArrayList<SourceRootWithPattern> selected = new ArrayList<SourceRootWithPattern>(this.children.length);
        for (SourceRootWithPattern child : this.children) {
            if (!child.getPattern().isEnabled()) continue;
            selected.add(child);
        }
        return selected.toArray(new SourceRootWithPattern[selected.size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public void addChangeListener(InstrumentedSourceFoldersListener listener) {
        this.listeners.add(listener);
    }

    public void notifyElementChange(SourceRootWithPattern element) {
        for (InstrumentedSourceFoldersListener listener : this.listeners) {
            listener.selectionChanged(element);
        }
    }

    public void notifyPerFolderSettingsEnabled(boolean enabled) {
        for (InstrumentedSourceFoldersListener listener : this.listeners) {
            listener.perFolderSelectionEnabled(enabled);
        }
    }
}

