/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source;

import com.atlassian.clover.cfg.instr.InstrumentationLevel;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.util.ArrayUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.LayoutUtils;
import org.openclover.eclipse.core.ui.CharDimensionConverter;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.SwtUtils;

public class InstrumentationComposite
extends Composite {
    private Button projectOutputDirButton;
    private Button userOutputDirButton;
    private Text userOutputDirText;
    private Button defaultInitStringButton;
    private Button userInitStringButton;
    private Text initStringText;
    private Button userInitStringRelativeButton;
    private Button qualifyJavaLangButton;
    private Button flushPolicyDirectedButton;
    private Button flushPolicyIntervalButton;
    private Button flushPolicyThreadedButton;
    private Text intervalText;
    private Button recreateOutputDirButton;
    private CloverProject cloverProject;
    private ProjectSettings projectSettings;
    private CharDimensionConverter charDimensionConverter;
    private Button compileWithCloverButton;
    private Combo instrumentationLevelCombo;
    private Combo instrumentLambdaCombo;

    public InstrumentationComposite(Composite parent, CharDimensionConverter converter, ProjectSettings properties, CloverProject cloverProject) throws CoreException {
        super(parent, 0);
        this.cloverProject = cloverProject;
        this.charDimensionConverter = converter;
        this.projectSettings = properties;
        this.setLayout((Layout)new GridLayout(2, true));
        this.createInitstringGroup(properties, this);
        this.createFlushGroup(properties, this);
        this.createOutputDirGroup(properties, this);
        this.createMiscGroup(properties, this);
    }

    public int getFlushInterval() throws NumberFormatException {
        return Integer.parseInt(this.intervalText.getText());
    }

    public int getFlushPolicy() {
        return this.flushPolicyDirectedButton.getSelection() ? 0 : (this.flushPolicyIntervalButton.getSelection() ? 1 : (this.flushPolicyThreadedButton.getSelection() ? 2 : 0));
    }

    public boolean isDefaultInitString() {
        return this.defaultInitStringButton.getSelection();
    }

    public String getCustomInitStringValue() {
        return this.initStringText.getText() != null ? this.initStringText.getText().trim() : "";
    }

    public boolean isCustomInitStringRelative() {
        return this.userInitStringRelativeButton.getSelection();
    }

    public boolean isProjectOutputDir() {
        return this.projectOutputDirButton.getSelection();
    }

    public String getCustomOutputDir() {
        return this.userOutputDirText.getText() != null ? this.userOutputDirText.getText().trim() : "";
    }

    public boolean isCustomOutputDirRecreateOriginal() {
        return this.recreateOutputDirButton.getSelection();
    }

    public boolean isQualifyJavaLangReferences() {
        return this.qualifyJavaLangButton.getSelection();
    }

    public boolean isInstrumentationEnabled() {
        return this.compileWithCloverButton.getSelection();
    }

    public InstrumentationLevel getInstrumentationLevel() {
        return this.instrumentationLevelCombo.getSelectionIndex() == 0 ? InstrumentationLevel.STATEMENT : InstrumentationLevel.METHOD;
    }

    public LambdaInstrumentation getInstrumentLambda() {
        int index = this.instrumentLambdaCombo.getSelectionIndex();
        if (index >= 0 && index < LambdaInstrumentation.values().length) {
            return LambdaInstrumentation.values()[this.instrumentLambdaCombo.getSelectionIndex()];
        }
        return ProjectSettings.Defaults.INSTRUMENT_LAMBDA;
    }

    public boolean isRebuildRequired() {
        return this.isMiscSettingsRebuildRequired() || this.isInstrumentationSettingsRebuildRequired() || this.isFlushSettingsRebuildRequired();
    }

    private boolean isFlushSettingsRebuildRequired() {
        return this.getFlushPolicy() != this.projectSettings.getFlushPolicy() || this.intervalText.isEnabled() && !this.intervalText.getText().equals(Integer.toString(this.projectSettings.getFlushInterval()));
    }

    private boolean isInstrumentationSettingsRebuildRequired() {
        return this.defaultInitStringButton.getSelection() != this.projectSettings.isInitStringDefault() || this.userInitStringButton.getSelection() == this.projectSettings.isInitStringDefault() || !this.initStringText.getText().equals(this.projectSettings.getInitString()) || this.userInitStringRelativeButton.getSelection() != this.projectSettings.isInitStringProjectRelative();
    }

    private boolean isMiscSettingsRebuildRequired() {
        return this.projectSettings.isInstrumentationEnabled() != this.isInstrumentationEnabled() || this.projectSettings.getInstrumentationLevel() != this.getInstrumentationLevel() || this.projectSettings.getInstrumentLambda() != this.getInstrumentLambda();
    }

    private void createInitstringGroup(ProjectSettings properties, Composite panel) throws CoreException {
        Group initStringGroup = LayoutUtils.createGroup(panel, CloverEclipsePluginMessages.INITSTRING());
        initStringGroup.setLayout((Layout)new GLH().standardiseMargin().getGridLayout());
        initStringGroup.setLayoutData((Object)new GridData(1808));
        SwtUtils.createMultilineLabel((Composite)initStringGroup, CloverEclipsePluginMessages.INITSTRING_BLURB(), this.charDimensionConverter.convertWidthInCharsToPixels(45));
        boolean defaultInitString = properties.isInitStringDefault();
        String initString = properties.getInitString();
        this.defaultInitStringButton = new Button((Composite)initStringGroup, 16);
        this.defaultInitStringButton.setText(CloverEclipsePluginMessages.INITSTRING_AUTOMATIC());
        this.defaultInitStringButton.setSelection(defaultInitString);
        this.defaultInitStringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InstrumentationComposite.this.initStringText.setEnabled(!InstrumentationComposite.this.defaultInitStringButton.getSelection());
                InstrumentationComposite.this.userInitStringRelativeButton.setEnabled(!InstrumentationComposite.this.defaultInitStringButton.getSelection());
            }
        });
        this.userInitStringButton = new Button((Composite)initStringGroup, 16);
        this.userInitStringButton.setText(CloverEclipsePluginMessages.INITSTRING_USER_SPECIFIED());
        this.userInitStringButton.setSelection(!defaultInitString);
        this.initStringText = new Text((Composite)initStringGroup, 2048);
        this.initStringText.setLayoutData((Object)new GridData(768));
        this.initStringText.setEnabled(!defaultInitString);
        this.initStringText.setText(initString == null ? "" : initString);
        this.userInitStringRelativeButton = new Button((Composite)initStringGroup, 32);
        this.userInitStringRelativeButton.setText(CloverEclipsePluginMessages.INITSTRING_RELATIVE());
        this.userInitStringRelativeButton.setSelection(properties.isInitStringProjectRelative());
        this.userInitStringRelativeButton.setEnabled(!defaultInitString);
    }

    private void createOutputDirGroup(ProjectSettings properties, Composite panel) throws CoreException {
        Group outputDirGroup = LayoutUtils.createGroup(panel, CloverEclipsePluginMessages.OUTPUT_FOLDER_GROUP());
        outputDirGroup.setLayoutData((Object)new GridData(1808));
        outputDirGroup.setLayout((Layout)new GLH(2, false).standardiseMargin().getGridLayout());
        Label label = new Label((Composite)outputDirGroup, 0);
        label.setText(CloverEclipsePluginMessages.OUTPUT_DIR());
        boolean outputToProjectDir = properties.isOutputRootSameAsProject();
        String outputRoot = properties.getOutputRoot();
        this.projectOutputDirButton = new Button((Composite)outputDirGroup, 16);
        SwtUtils.setHorizontalSpan((Control)this.projectOutputDirButton, 2);
        this.projectOutputDirButton.setText(CloverEclipsePluginMessages.PLACE_IN_PROJECT_DIRS());
        this.projectOutputDirButton.setSelection(outputToProjectDir);
        this.userOutputDirButton = new Button((Composite)outputDirGroup, 16);
        this.userOutputDirButton.setLayoutData((Object)new GridData());
        SwtUtils.setHorizontalSpan((Control)this.userOutputDirButton, 2);
        this.userOutputDirButton.setText(CloverEclipsePluginMessages.PLACE_IN_USER_DIRS());
        this.userOutputDirButton.setSelection(!outputToProjectDir);
        this.userOutputDirText = new Text((Composite)outputDirGroup, 2048);
        this.userOutputDirText.setLayoutData((Object)new GridData(768));
        this.userOutputDirText.setEnabled(this.userOutputDirButton.getSelection());
        this.userOutputDirText.setText(outputRoot == null ? "" : outputRoot);
        final Button dirButton = new Button((Composite)outputDirGroup, 0);
        dirButton.setLayoutData((Object)new GridData());
        dirButton.setText("...");
        dirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(InstrumentationComposite.this.getShell(), null, true, CloverEclipsePluginMessages.OUTPUT_FOLDER_DIALOG_CAPTION());
                dialog.showClosedProjects(false);
                dialog.setValidator(new ISelectionValidator(){

                    public String isValid(Object o) {
                        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)o);
                        IProject project = container.getProject();
                        if (project != container && project == InstrumentationComposite.this.cloverProject.getProject()) {
                            return null;
                        }
                        return CloverEclipsePluginMessages.ERROR_SELECT_WITHIN_PROJECT();
                    }
                });
                if (dialog.open() == 0) {
                    IPath selection = (IPath)dialog.getResult()[0];
                    InstrumentationComposite.this.userOutputDirText.setText(selection.removeFirstSegments(InstrumentationComposite.this.cloverProject.getProject().getFullPath().segmentCount()).toString());
                }
            }
        });
        this.userOutputDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InstrumentationComposite.this.userOutputDirText.setEnabled(InstrumentationComposite.this.userOutputDirButton.getSelection());
                InstrumentationComposite.this.recreateOutputDirButton.setEnabled(InstrumentationComposite.this.userOutputDirButton.getSelection());
                dirButton.setEnabled(InstrumentationComposite.this.userOutputDirButton.getSelection());
            }
        });
        this.recreateOutputDirButton = new Button((Composite)outputDirGroup, 32);
        this.recreateOutputDirButton.setText(CloverEclipsePluginMessages.OUTPUT_FOLDER_RECREATE_ORIGINAL_FOLDERS());
        this.recreateOutputDirButton.setToolTipText(CloverEclipsePluginMessages.OUTPUT_FOLDER_RECREATE_ORIGINAL_FOLDERS_TOOLTIP());
        this.recreateOutputDirButton.setEnabled(!outputToProjectDir);
        this.recreateOutputDirButton.setSelection(properties.isRecreateOutputDirs());
    }

    private void createMiscGroup(ProjectSettings properties, Composite panel) {
        Group miscGroup = LayoutUtils.createGroup(panel, CloverEclipsePluginMessages.MISC_INSTRUMENTATION());
        miscGroup.setLayout((Layout)new GLH(1, false).standardiseMargin().getGridLayout());
        miscGroup.setLayoutData((Object)new GridData(1808));
        this.createQualifyJavaLangWidget(properties, (Composite)miscGroup);
        this.createInstrumentationLevelWidget(properties, (Composite)miscGroup);
        this.createIntrumentLambdaWidget(properties, (Composite)miscGroup);
    }

    private void createQualifyJavaLangWidget(ProjectSettings properties, Composite parent) {
        this.qualifyJavaLangButton = new Button(parent, 32);
        this.qualifyJavaLangButton.setText(CloverEclipsePluginMessages.QUALIFY_JAVA_LANG());
        this.qualifyJavaLangButton.setSelection(properties.shouldQualifyJavaLang());
    }

    private void createInstrumentationLevelWidget(ProjectSettings properties, Composite parent) {
        Composite instrumentationComposite = new Composite(parent, 0);
        instrumentationComposite.setLayout((Layout)new GLH(2, false).marginWidth(0).getGridLayout());
        this.compileWithCloverButton = new Button(instrumentationComposite, 32);
        this.compileWithCloverButton.setText("Instrument and compile at ");
        this.compileWithCloverButton.setToolTipText("Choose whether Clover should instrument and compile your source code and what coverage granularity.\n\nThis can be switched off if you wish to develop without tracking code coverage for a period of time or if you have configured Clover-for-Ant or Clover-for-Maven to instrument and compile your source for you.");
        this.compileWithCloverButton.setSelection(properties.isInstrumentationEnabled());
        this.instrumentationLevelCombo = new Combo(instrumentationComposite, 40);
        this.instrumentationLevelCombo.setItems(new String[]{"statement level", "method level"});
        this.instrumentationLevelCombo.select(properties.getInstrumentationLevel() == InstrumentationLevel.STATEMENT ? 0 : 1);
        this.instrumentationLevelCombo.setToolTipText("Statement level instrumentation is more accurate but has a runtime performance penalty.Method level instrumentation is less accurate but will run faster and Clover will be able to provide coverage feedback more switfly.\n\nIf you only use Clover for optimizing your test runs, method level instrumenation is the best option.");
        this.instrumentationLevelCombo.setEnabled(properties.isInstrumentationEnabled());
        SelectionAdapter onChangeEnableLevelCombo = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstrumentationComposite.this.instrumentationLevelCombo.setEnabled(InstrumentationComposite.this.compileWithCloverButton.getSelection());
            }
        };
        this.compileWithCloverButton.addSelectionListener((SelectionListener)onChangeEnableLevelCombo);
    }

    private void createIntrumentLambdaWidget(ProjectSettings properties, Composite parent) {
        Composite box = new Composite(parent, 0);
        box.setLayout((Layout)new GLH(2, false).marginWidth(0).getGridLayout());
        Label instrumentLambdaLabel = new Label(box, 0);
        instrumentLambdaLabel.setText("Instrument lambda functions ");
        this.instrumentLambdaCombo = new Combo(box, 40);
        this.instrumentLambdaCombo.setItems(ArrayUtil.toLowerCaseStringArray((Object[])LambdaInstrumentation.values()));
        this.instrumentLambdaCombo.select(properties.getInstrumentLambda().ordinal());
        this.instrumentLambdaCombo.setToolTipText("Select whether lambda functions introduced in Java 8 shall be instrumented by Clover so that you can track \ncode coverage for them and show them in reports similarly as normal methods. \nYou can also limit instrumentation to certain form of lambda functions: \n * written as expressions, e.g. '(a + b) -> a + b' \n * written as code blocks, e.g. '() -> { return xyz(); }' \n * written in any form except method references, e.g. 'Math::abs'");
    }

    private void createFlushGroup(ProjectSettings properties, Composite panel) throws CoreException {
        Group flushPolicyGroup = LayoutUtils.createGroup(panel, CloverEclipsePluginMessages.FLUSH_POLICY());
        flushPolicyGroup.setLayout((Layout)new GLH(2, false).standardiseMargin().getGridLayout());
        flushPolicyGroup.setLayoutData((Object)new GridData(1808));
        Label explanationLabel = SwtUtils.createMultilineLabel((Composite)flushPolicyGroup, CloverEclipsePluginMessages.FLUSH_POLICY_EXPLANATION(), this.charDimensionConverter.convertWidthInCharsToPixels(45));
        SwtUtils.setHorizontalSpan((Control)explanationLabel, 2);
        int flushPolicy = properties.getFlushPolicy();
        this.flushPolicyDirectedButton = new Button((Composite)flushPolicyGroup, 16);
        this.flushPolicyDirectedButton.setText(CloverEclipsePluginMessages.FLUSH_POLICY_DIRECTED());
        this.flushPolicyDirectedButton.setSelection(flushPolicy == 0);
        SwtUtils.setHorizontalSpan((Control)this.flushPolicyDirectedButton, 2);
        this.flushPolicyIntervalButton = new Button((Composite)flushPolicyGroup, 16);
        this.flushPolicyIntervalButton.setText(CloverEclipsePluginMessages.FLUSH_POLICY_INTERVAL());
        this.flushPolicyIntervalButton.setSelection(flushPolicy == 1);
        this.flushPolicyIntervalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InstrumentationComposite.this.intervalText.setEnabled(InstrumentationComposite.this.flushPolicyIntervalButton.getSelection() || InstrumentationComposite.this.flushPolicyThreadedButton.getSelection());
            }
        });
        SwtUtils.setHorizontalSpan((Control)this.flushPolicyIntervalButton, 1);
        Composite intervalComposite = new Composite((Composite)flushPolicyGroup, 0);
        intervalComposite.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = SwtUtils.gridDataFor((Control)intervalComposite);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 32;
        gridData.verticalAlignment = 4;
        this.intervalText = new Text(intervalComposite, 2048);
        this.intervalText.setText(Integer.toString(properties.getFlushInterval()));
        gridData = SwtUtils.gridDataFor((Control)this.intervalText);
        gridData.horizontalAlignment = 256;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 50;
        Label msLabel = new Label(intervalComposite, 0);
        msLabel.setText(CloverEclipsePluginMessages.FLUSH_POLICY_INTERVAL_MILISECONDS());
        this.flushPolicyThreadedButton = new Button((Composite)flushPolicyGroup, 16);
        this.flushPolicyThreadedButton.setText(CloverEclipsePluginMessages.FLUSH_POLICY_THREADED());
        this.flushPolicyThreadedButton.setSelection(flushPolicy == 2);
        this.flushPolicyThreadedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InstrumentationComposite.this.intervalText.setEnabled(InstrumentationComposite.this.flushPolicyIntervalButton.getSelection() || InstrumentationComposite.this.flushPolicyThreadedButton.getSelection());
            }
        });
        SwtUtils.setHorizontalSpan((Control)this.flushPolicyThreadedButton, 1);
        this.intervalText.setEnabled(this.flushPolicyIntervalButton.getSelection() || this.flushPolicyThreadedButton.getSelection());
    }
}

