/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.EditSourceFolderPatternDialog;
import org.openclover.eclipse.core.projects.settings.source.FolderWithPatternLabelProvider;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;
import org.openclover.eclipse.core.projects.settings.source.SourceRootWithPattern;
import org.openclover.eclipse.core.projects.settings.source.SourceRootsWithPatternTreeContentProvider;
import org.openclover.eclipse.core.ui.SwtUtils;

public class InstrumentSourcePatternsComponent
extends Composite {
    private final CheckboxTableViewer foldersListViewer;
    private final Button editBtn;
    private List<SourceFolderPattern> lastPatterns;
    private final SourceRootsWithPatternTreeContentProvider contentProvider;

    public InstrumentSourcePatternsComponent(Composite parent, final SourceRootsWithPatternTreeContentProvider contentProvider) {
        super(parent, 0);
        this.contentProvider = contentProvider;
        this.lastPatterns = InstrumentSourcePatternsComponent.getSFPList(contentProvider);
        this.setLayout((Layout)new GridLayout(2, false));
        this.foldersListViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2560);
        this.foldersListViewer.setLabelProvider((IBaseLabelProvider)new FolderWithPatternLabelProvider());
        this.foldersListViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SourceRootWithPattern element = (SourceRootWithPattern)event.getElement();
                element.getPattern().setEnabled(event.getChecked());
                contentProvider.notifyElementChange(element);
            }
        });
        this.foldersListViewer.setContentProvider((IContentProvider)contentProvider);
        this.foldersListViewer.setInput((Object)contentProvider.getProject());
        this.foldersListViewer.setCheckedElements((Object[])contentProvider.getEnabledElements());
        GridData gd = SwtUtils.gridDataFor(this.foldersListViewer.getControl());
        gd.verticalSpan = 2;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.minimumWidth = 512;
        this.editBtn = new Button((Composite)this, 0);
        this.editBtn.setText("Edit");
        this.editBtn.setLayoutData((Object)new GridData(4, 0, true, false));
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstrumentSourcePatternsComponent.this.doEdit();
            }
        });
        new Label((Composite)this, 0);
        this.foldersListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InstrumentSourcePatternsComponent.this.updateButtonStateAndUpdateListeners();
            }
        });
    }

    private void updateButtonStateAndUpdateListeners() {
        boolean enabled = this.isEnabled();
        this.editBtn.setEnabled(enabled && !this.foldersListViewer.getSelection().isEmpty());
        this.contentProvider.notifyPerFolderSettingsEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.foldersListViewer.getControl().setEnabled(enabled);
        this.updateButtonStateAndUpdateListeners();
    }

    private void doEdit() {
        EditSourceFolderPatternDialog dialog;
        StructuredSelection selection = (StructuredSelection)this.foldersListViewer.getSelection();
        SourceRootWithPattern srwp = (SourceRootWithPattern)selection.getFirstElement();
        if (srwp != null && (dialog = new EditSourceFolderPatternDialog(this.getShell(), srwp.getPattern())).open() == 0) {
            SourceFolderPattern newSfp = dialog.getResult();
            srwp.setPattern(newSfp);
            this.foldersListViewer.refresh((Object)srwp);
        }
    }

    private static List<SourceFolderPattern> getSFPList(SourceRootsWithPatternTreeContentProvider provider) {
        SourceRootWithPattern[] elements = provider.getAllElements();
        ArrayList<SourceFolderPattern> patterns = new ArrayList<SourceFolderPattern>(elements.length);
        for (SourceRootWithPattern srwp : elements) {
            patterns.add(new SourceFolderPattern(srwp.getPattern()));
        }
        return patterns;
    }

    public void storeTo(ProjectSettings settings) {
        this.lastPatterns = InstrumentSourcePatternsComponent.getSFPList(this.contentProvider);
        settings.setInstrumentedFolderPatterns(this.lastPatterns);
    }

    public boolean isModified() {
        SourceRootWithPattern[] elements = this.contentProvider.getAllElements();
        Iterator<SourceFolderPattern> i = this.lastPatterns.iterator();
        for (SourceRootWithPattern element : elements) {
            if (element.getPattern().equals(i.next())) continue;
            return true;
        }
        return false;
    }
}

