/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.InstrumentSourcePatternsComponent;
import org.openclover.eclipse.core.projects.settings.source.LayoutUtils;
import org.openclover.eclipse.core.projects.settings.source.SourceRootsWithPatternTreeContentProvider;
import org.openclover.eclipse.core.settings.InstallationSettings;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.ui.widgets.MessageDialogWithCheckbox;

public class InstrumentSourceFilteringComposite
extends Composite {
    private final Button filterFoldersAllButton;
    private final Button filterFoldersSelectedButton;
    private final InstrumentSourcePatternsComponent instrumentSourcePatternsComponent;
    private final Text includeFilterText;
    private final Text excludeFilterText;
    private String lastInclude;
    private String lastExclude;
    private boolean lastInstrumentSelectedSourceFolders;

    public InstrumentSourceFilteringComposite(Composite parent, ProjectSettings properties, SourceRootsWithPatternTreeContentProvider contentProvider) {
        super(parent, 0);
        this.lastInclude = properties.getIncludeFilter() == null ? "**/*.java" : properties.getIncludeFilter();
        this.lastExclude = properties.getExcludeFilter() == null ? "" : properties.getExcludeFilter();
        this.lastInstrumentSelectedSourceFolders = properties.isInstrumentSelectedSourceFolders();
        Group filteringGroup = LayoutUtils.createGroup(this, CloverEclipsePluginMessages.FILE_FILTERING());
        filteringGroup.setLayout((Layout)new GLH().standardiseMargin().getGridLayout());
        filteringGroup.setLayoutData((Object)new GridData(768));
        this.filterFoldersAllButton = new Button((Composite)filteringGroup, 16);
        this.filterFoldersAllButton.setText(CloverEclipsePluginMessages.FILE_FILTERING_ALL_FOLDERS());
        Composite c = new Composite((Composite)filteringGroup, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalIndent = 30;
        c.setLayoutData((Object)gd);
        final Label includeLabel = new Label(c, 0);
        includeLabel.setText(CloverEclipsePluginMessages.FILE_FILTERING_INCLUDE());
        this.includeFilterText = new Text(c, 2048);
        this.includeFilterText.setText(this.lastInclude);
        this.includeFilterText.setLayoutData((Object)new GridData(768));
        final Label excludeLabel = new Label(c, 0);
        excludeLabel.setText(CloverEclipsePluginMessages.FILE_FILTERING_EXCLUDE());
        this.excludeFilterText = new Text(c, 2048);
        this.excludeFilterText.setText(this.lastExclude);
        this.excludeFilterText.setLayoutData((Object)new GridData(768));
        this.filterFoldersSelectedButton = new Button((Composite)filteringGroup, 16);
        this.filterFoldersSelectedButton.setText(CloverEclipsePluginMessages.FILE_FILTERING_SELECTED_FOLDERS());
        this.instrumentSourcePatternsComponent = new InstrumentSourcePatternsComponent((Composite)filteringGroup, contentProvider);
        GridData gd1 = SwtUtils.gridDataFor((Control)this.instrumentSourcePatternsComponent);
        gd1.horizontalIndent = 30;
        gd1.minimumHeight = 100;
        gd1.grabExcessVerticalSpace = true;
        if (this.lastInstrumentSelectedSourceFolders) {
            this.filterFoldersSelectedButton.setSelection(true);
        } else {
            this.filterFoldersAllButton.setSelection(true);
        }
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean enableAllPart = InstrumentSourceFilteringComposite.this.filterFoldersAllButton.getSelection();
                includeLabel.setEnabled(enableAllPart);
                excludeLabel.setEnabled(enableAllPart);
                InstrumentSourceFilteringComposite.this.includeFilterText.setEnabled(enableAllPart);
                InstrumentSourceFilteringComposite.this.excludeFilterText.setEnabled(enableAllPart);
                InstrumentSourceFilteringComposite.this.instrumentSourcePatternsComponent.setEnabled(!enableAllPart);
            }
        };
        this.filterFoldersAllButton.addSelectionListener((SelectionListener)adapter);
        adapter.widgetSelected(null);
    }

    public void storeTo(ProjectSettings settings) {
        this.lastInstrumentSelectedSourceFolders = this.filterFoldersSelectedButton.getSelection();
        settings.setInstrumentSelectedSourceFolders(this.lastInstrumentSelectedSourceFolders);
        this.lastInclude = this.includeFilterText.getText().trim();
        settings.setIncludeFilter(this.lastInclude.length() > 0 ? this.lastInclude : null);
        this.lastExclude = this.excludeFilterText.getText().trim();
        settings.setExcludeFilter(this.lastExclude.length() > 0 ? this.lastExclude : null);
        this.instrumentSourcePatternsComponent.storeTo(settings);
    }

    public boolean isModified() {
        if (this.filterFoldersSelectedButton.getSelection() != this.lastInstrumentSelectedSourceFolders) {
            return true;
        }
        if (this.filterFoldersSelectedButton.getSelection()) {
            return this.instrumentSourcePatternsComponent.isModified();
        }
        return !this.includeFilterText.getText().trim().equals(this.lastInclude) || !this.excludeFilterText.getText().trim().equals(this.lastExclude);
    }

    public static boolean askForRebuild() {
        InstallationSettings installationSettings = CloverPlugin.getInstance().getInstallationSettings();
        if (installationSettings.isPromptingOnInstrumentationSourceChange()) {
            MessageDialogWithCheckbox.Result result = new MessageDialogWithCheckbox.Result();
            MessageDialogWithCheckbox.openQuestion(null, CloverEclipsePluginMessages.INSTRUMENTATION_SOURCE_CHANGED_TITLE(), CloverEclipsePluginMessages.INSTRUMENTATION_SOURCE_CHANGED_QUESTION(), true, CloverEclipsePluginMessages.DISPLAY_THIS_PROMPT_AGAIN(), true, result);
            installationSettings.setLatestPromptOnInstrumentationSourceChange(result.isYesSelected());
            installationSettings.isPromptingOnInstrumentationSourceChange(result.isChecked());
            return result.isYesSelected();
        }
        return installationSettings.isRebuildingOnInstrumentationSourceChange();
    }
}

