/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.CloverDatabase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.CoverageModelChangeEvent;
import org.openclover.eclipse.core.projects.model.LoadDatabaseJob;

public class RefreshCoverageJob
extends LoadDatabaseJob {
    private final CloverDatabase database;

    public RefreshCoverageJob(CloverProject project, CloverDatabase database, CoverageModelChangeEvent changeEvent) {
        super("Loading coverage for project " + project.getName(), project, changeEvent);
        this.database = database;
    }

    @Override
    public IStatus doLoad(IProgressMonitor monitor) {
        if (this.hasRun.compareAndSet(false, true)) {
            try {
                this.database.loadCoverageData(this.project.newCoverageDataSpec(this.database));
                this.status = Status.OK_STATUS;
            }
            catch (Throwable t) {
                CloverPlugin.logError("Failed to load coverage data", t);
                this.status = new Status(2, "org.openclover.eclipse.core", 0, "Background job: failed to load coverage data for project " + this.project.getName(), t);
            }
            this.setDatabase(this.database);
        }
        return this.status;
    }
}

