/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.model.ClosedDatabaseModel;
import org.openclover.eclipse.core.projects.model.CoverageModelChangeEvent;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.projects.model.LoadDatabaseJob;
import org.openclover.eclipse.core.projects.model.LoadedDatabaseModel;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.projects.model.StableDatabaseModel;
import org.openclover.eclipse.core.projects.model.VolatileDatabaseModel;

public class LoadingDatabaseModel
extends VolatileDatabaseModel {
    protected StableDatabaseModel currentModel;
    protected LoadDatabaseJob loadingJob;

    public LoadingDatabaseModel(StableDatabaseModel currentModel, CoverageModelChangeEvent changeEvent) {
        super(currentModel.project, changeEvent);
        this.currentModel = currentModel;
    }

    @Override
    public CloverDatabase getDatabase() {
        return this.currentModel.getDatabase();
    }

    @Override
    public void close(CoverageModelChangeEvent changeEvent) {
        this.project.setModel(new ClosedDatabaseModel(this.project, changeEvent));
    }

    @Override
    public boolean isLoaded() {
        return this.currentModel.isLoaded();
    }

    @Override
    public boolean isLoading() {
        return true;
    }

    @Override
    public boolean isCoverageOutOfDate() {
        return false;
    }

    @Override
    public boolean isRegistryOfDate() {
        return false;
    }

    protected void onLoadOK(IJobChangeEvent event) {
        CloverPlugin.logVerbose("Database load succeeded for project " + this.project.getName());
        CloverPlugin.logVerbose("Attempting to set coverage model to loaded for project " + this.project.getName());
        boolean includeFailedCoverage = CloverPlugin.getInstance().getInstallationSettings().isIncludeFailedCoverage();
        this.project.compareAndSetModel(this, new LoadedDatabaseModel(this.project, ((LoadDatabaseJob)event.getJob()).getDatabase(), this.changeEvent, includeFailedCoverage));
    }

    protected void onLoadNotOK(IJobChangeEvent event) {
        CloverPlugin.logVerbose("Database load failed: " + (event.getResult() == null ? "unknown reason" : event.getResult().getMessage()));
        CloverDatabase database = ((LoadDatabaseJob)event.getJob()).getDatabase();
        boolean includeFailedCoverage = CloverPlugin.getInstance().getInstallationSettings().isIncludeFailedCoverage();
        if (database != null) {
            this.project.compareAndSetModel(this, new LoadedDatabaseModel(this.project, database, this.changeEvent, includeFailedCoverage));
        } else {
            this.project.compareAndSetModel(this, new LoadedDatabaseModel(this.project, this.project.newEmptyDatabase(this.loadingJob.contextFilter), this.changeEvent, includeFailedCoverage));
        }
    }

    @Override
    public void onActivation(DatabaseModel predecessor) {
        super.onActivation(predecessor);
        this.loadingJob = this.createJob();
        this.loadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    LoadingDatabaseModel.this.onLoadOK(event);
                } else {
                    LoadingDatabaseModel.this.onLoadNotOK(event);
                }
            }
        });
        CloverPlugin.logVerbose("Starting database load for " + this);
        this.loadingJob.schedule();
    }

    protected LoadDatabaseJob createJob() {
        return new LoadDatabaseJob(this.project, this.changeEvent);
    }

    @Override
    public CloverDatabase forcePrematureLoad(IProgressMonitor monitor) {
        CloverDatabase database;
        if (this.loadingJob != null) {
            this.loadingJob.doLoad(monitor);
            database = this.loadingJob.getDatabase();
        } else {
            database = null;
        }
        return database;
    }

    @Override
    public void onDeactication(DatabaseModel successor) {
        if (this.loadingJob != null) {
            if (this.loadingJob.getState() != 0) {
                CloverPlugin.logVerbose("Cancelling database load for " + this);
            }
            Job.getJobManager().cancel((Object)this.loadingJob);
        }
    }

    @Override
    public FullProjectInfo getFullProjectInfo() {
        return this.currentModel.getFullProjectInfo();
    }

    @Override
    public FullProjectInfo getTestOnlyProjectInfo() {
        return this.currentModel.getTestOnlyProjectInfo();
    }

    @Override
    public FullProjectInfo getAppOnlyProjectInfo() {
        return this.currentModel.getAppOnlyProjectInfo();
    }

    @Override
    public HasMetrics getPackageInfoOrFragment(IPackageFragment pack, MetricsScope scope) {
        return this.currentModel.getPackageInfoOrFragment(pack, scope);
    }

    @Override
    public BaseFileInfo getSourceFileInfo(ICompilationUnit cu, MetricsScope scope) {
        return this.currentModel.getSourceFileInfo(cu, scope);
    }

    @Override
    public BaseClassInfo getTypeInfo(IType type, MetricsScope scope) {
        return this.currentModel.getTypeInfo(type, scope);
    }

    @Override
    public TestCaseInfo getTestCaseInfo(IMethod method, MetricsScope scope) {
        return this.currentModel.getTestCaseInfo(method, scope);
    }

    @Override
    public TestCaseInfo[] getTestCaseInfos(IMethod method, MetricsScope scope) {
        return this.currentModel.getTestCaseInfos(method, scope);
    }

    @Override
    public FullMethodInfo getMethodInfo(IMethod method, MetricsScope scope) {
        return this.currentModel.getMethodInfo(method, scope);
    }

    @Override
    public HasMetrics metricsProviderFor(Object projectArtifact, MetricsScope scope) {
        return this.currentModel.metricsProviderFor(projectArtifact, scope);
    }
}

