/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.MaskedBitSetCoverageProvider;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.MethodSignatureInfo;
import com.atlassian.clover.api.registry.ParameterInfo;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.CoverageModelChangeEvent;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.projects.model.RefreshingCoverageModel;
import org.openclover.eclipse.core.projects.model.StableDatabaseModel;

public class LoadedDatabaseModel
extends StableDatabaseModel {
    protected CloverDatabase database;

    public LoadedDatabaseModel(CloverProject project, CloverDatabase database, CoverageModelChangeEvent changeEvent, boolean includeFailedCoverage) {
        super(project, changeEvent);
        if (!includeFailedCoverage) {
            CoverageData data = database.getCoverageData();
            MaskedBitSetCoverageProvider provider = new MaskedBitSetCoverageProvider(data.getPassOnlyAndIncidentalHits(), data, data);
            database.getFullModel().setDataProvider(provider);
            database.getAppOnlyModel().setDataProvider(provider);
            database.getTestOnlyModel().setDataProvider(provider);
        }
        this.database = database;
    }

    @Override
    public CloverDatabase getDatabase() {
        return this.database;
    }

    @Override
    public void refreshCoverage(CoverageModelChangeEvent changeEvent) {
        this.project.setModel(new RefreshingCoverageModel(this, this.database, changeEvent));
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean isLoading() {
        return false;
    }

    @Override
    public boolean isCoverageOutOfDate() {
        return !this.database.isRecordingInProgress() && this.database.isCoverageOutOfDate();
    }

    @Override
    public boolean isRegistryOfDate() {
        return this.database.isRegistryOutOfDate();
    }

    @Override
    public FullProjectInfo getFullProjectInfo() {
        return this.database.getFullModel();
    }

    @Override
    public FullProjectInfo getTestOnlyProjectInfo() {
        return this.database.getTestOnlyModel();
    }

    @Override
    public FullProjectInfo getAppOnlyProjectInfo() {
        return this.database.getAppOnlyModel();
    }

    @Override
    public HasMetrics getPackageInfoOrFragment(IPackageFragment pack, MetricsScope scope) {
        BasePackageInfo result = scope.getProjectInfoFor(this.project).getNamedPackage(pack.getElementName());
        return result == null ? scope.getProjectInfoFor(this.project).findPackageFragment(pack.getElementName()) : result;
    }

    @Override
    public BaseFileInfo getSourceFileInfo(ICompilationUnit cu, MetricsScope scope) {
        BasePackageInfo packageInfo = scope.getProjectInfoFor(this.project).getNamedPackage(cu.getParent().getElementName());
        return packageInfo == null ? null : packageInfo.getFileInPackage(cu.getElementName());
    }

    @Override
    public BaseClassInfo getTypeInfo(IType type, MetricsScope scope) {
        return (BaseClassInfo)scope.getProjectInfoFor(this.project).findClass(type.getFullyQualifiedName('.'));
    }

    @Override
    public FullMethodInfo getMethodInfo(IMethod method, MetricsScope scope) {
        ClassInfo classInfo = scope.getProjectInfoFor(this.project).findClass(method.getDeclaringType().getFullyQualifiedName('.'));
        if (classInfo instanceof FullClassInfo) {
            for (MethodInfo methodInfo : classInfo.getMethods()) {
                MethodSignatureInfo sig = methodInfo.getSignature();
                if (!sig.getName().equals(method.getElementName())) continue;
                Object[] paramTypes1 = this.toEclipseSignatures(sig.getParameters());
                Object[] paramTypes2 = method.getParameterTypes();
                if (!Arrays.equals(paramTypes2, paramTypes1)) continue;
                return (FullMethodInfo)methodInfo;
            }
        }
        return null;
    }

    @Override
    public TestCaseInfo getTestCaseInfo(IMethod method, MetricsScope scope) {
        ClassInfo classInfo = scope.getProjectInfoFor(this.project).findClass(method.getDeclaringType().getFullyQualifiedName('.'));
        if (classInfo instanceof FullClassInfo) {
            Collection<TestCaseInfo> testCases = ((FullClassInfo)classInfo).getTestCases();
            for (TestCaseInfo testCase : testCases) {
                MethodSignature sig;
                FullMethodInfo methodInfo = testCase.getSourceMethod();
                if (methodInfo == null || (sig = methodInfo.getSignature()) == null || !sig.getName().equals(method.getElementName())) continue;
                Object[] paramTypes1 = this.toEclipseSignatures(sig.getParameters());
                Object[] paramTypes2 = method.getParameterTypes();
                if (!Arrays.equals(paramTypes2, paramTypes1)) continue;
                return testCase;
            }
        }
        return null;
    }

    @Override
    public TestCaseInfo[] getTestCaseInfos(IMethod method, MetricsScope scope) {
        ClassInfo classInfo = scope.getProjectInfoFor(this.project).findClass(method.getDeclaringType().getFullyQualifiedName('.'));
        if (classInfo instanceof FullClassInfo) {
            Collection<TestCaseInfo> testCases = ((FullClassInfo)classInfo).getTestCases();
            Iterator<TestCaseInfo> iter = testCases.iterator();
            while (iter.hasNext()) {
                MethodSignature sig;
                TestCaseInfo testCase = iter.next();
                FullMethodInfo methodInfo = testCase.getSourceMethod();
                if (methodInfo == null || (sig = methodInfo.getSignature()) != null && sig.getName().equals(method.getElementName()) && Arrays.equals(method.getParameterTypes(), this.toEclipseSignatures(sig.getParameters()))) continue;
                iter.remove();
            }
            return testCases.toArray(new TestCaseInfo[testCases.size()]);
        }
        return new TestCaseInfo[0];
    }

    private String[] toEclipseSignatures(ParameterInfo[] signatures) {
        String[] eclipseSignatures = new String[signatures.length];
        for (int i = 0; i < eclipseSignatures.length; ++i) {
            eclipseSignatures[i] = this.toEclipseSignature(signatures[i].getType());
        }
        return eclipseSignatures;
    }

    private String toEclipseSignature(String sig) {
        return Signature.createTypeSignature((String)sig, (boolean)false);
    }

    @Override
    public HasMetrics metricsProviderFor(Object object, MetricsScope scope) {
        if (object instanceof IProject) {
            return scope.getProjectInfoFor(this.project);
        }
        if (object instanceof IPackageFragment) {
            return this.getPackageInfoOrFragment((IPackageFragment)object, scope);
        }
        if (object instanceof ICompilationUnit) {
            return this.getSourceFileInfo((ICompilationUnit)object, scope);
        }
        if (object instanceof IType) {
            return this.getTypeInfo((IType)object, scope);
        }
        if (object instanceof IMethod) {
            return this.getMethodInfo((IMethod)object, scope);
        }
        return null;
    }
}

