/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.Current;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.projects.model.WorkingSetHasMetricsFilter;

public class InMemoryCurrentReportConfig
extends Current {
    private DatabaseModel inMemoryModel;

    public InMemoryCurrentReportConfig(DatabaseModel inMemoryModel) {
        this.inMemoryModel = inMemoryModel;
    }

    public InMemoryCurrentReportConfig(DatabaseModel inMemoryModel, Current other) {
        super(other);
        this.inMemoryModel = inMemoryModel;
    }

    @Override
    public CloverDatabase getCoverageDatabase() throws CloverException {
        return this.inMemoryModel.getDatabase();
    }

    private HasMetricsFilter getWorkingSetFilter() {
        return CloverPlugin.getInstance().isInWorkingSetMode() ? new WorkingSetHasMetricsFilter(this.inMemoryModel.getProject()) : HasMetricsFilter.ACCEPT_ALL;
    }
}

