/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.BaseInvertableFilter;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.filters.AntPatternTestFilter;
import com.atlassian.clover.reporters.filters.DefaultTestFilter;
import com.atlassian.clover.reporters.filters.EmptyTestFilter;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;

public class FoldersAwareTestFilter
extends BaseInvertableFilter {
    private final List<File> srcFolders;

    public FoldersAwareTestFilter(boolean inverted, List<File> srcFolders) {
        super(inverted);
        this.srcFolders = srcFolders;
    }

    public FoldersAwareTestFilter(CloverProject project, List<String> selectedFolders) {
        this.srcFolders = new ArrayList<File>(selectedFolders.size());
        IProject iProject = project.getProject();
        for (String selectedFolder : selectedFolders) {
            IResource srcFolder = iProject.findMember(selectedFolder);
            if (srcFolder == null) continue;
            this.srcFolders.add(srcFolder.getLocation().toFile());
        }
    }

    @Override
    public FoldersAwareTestFilter invert() {
        return new FoldersAwareTestFilter(!this.isInverted(), this.srcFolders);
    }

    @Override
    public boolean accept(HasMetrics hm) {
        if (hm instanceof FullClassInfo) {
            FullClassInfo ci = (FullClassInfo)hm;
            File file = ((FullFileInfo)ci.getContainingFile()).getPhysicalFile();
            boolean matched = false;
            for (File src : this.srcFolders) {
                if (!FileUtils.isAncestorOf(src, file)) continue;
                matched = true;
                break;
            }
            return this.isInverted() ^ matched;
        }
        return true;
    }

    public static HasMetricsFilter.Invertable getFor(CloverProject project) {
        ProjectSettings settings;
        if (project != null && (settings = project.getSettings()) != null) {
            switch (settings.getTestSourceFolders()) {
                case 1: {
                    return new FoldersAwareTestFilter(project, settings.getSelectedTestFolders());
                }
                case 0: {
                    return new AntPatternTestFilter(project.getProject().getLocation().toString(), settings.calculateTestIncludeFilter(), settings.calculateTestExcludeFilter());
                }
            }
            return new EmptyTestFilter();
        }
        return new DefaultTestFilter();
    }
}

