/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.openclover.eclipse.core.projects.CloverProject;

public class FolderAwareTestDetectorFilter
implements TestDetector {
    private final List<File> srcFolders;

    public FolderAwareTestDetectorFilter(CloverProject project, List<String> selectedFolders) {
        this.srcFolders = new ArrayList<File>(selectedFolders.size());
        IProject iProject = project.getProject();
        for (String selectedFolder : selectedFolders) {
            IResource srcFolder = iProject.findMember(selectedFolder);
            if (srcFolder == null) continue;
            this.srcFolders.add(srcFolder.getLocation().toFile());
        }
    }

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        return this.isInTestFolder(sourceContext.getSourceFile());
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        return this.isInTestFolder(sourceContext.getSourceFile());
    }

    private boolean isInTestFolder(File file) {
        for (File src : this.srcFolders) {
            if (!FileUtils.isAncestorOf(src, file)) continue;
            return true;
        }
        return false;
    }
}

