/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.instr.java.FileInstrumentationSource;
import com.atlassian.clover.registry.Clover2Registry;
import java.io.CharArrayWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.BaseInstrumenter;
import org.openclover.eclipse.core.projects.builder.InstrumentationProjectPathMap;

public class InMemoryInstrumenter
extends BaseInstrumenter {
    private Map originalToInstrumentedSource = new LinkedHashMap();

    public InMemoryInstrumenter(CloverProject project, Clover2Registry registry, InstrumentationProjectPathMap pathMap, IProgressMonitor monitor, int buildKind) throws CoreException {
        super(monitor, pathMap, project, registry, buildKind);
    }

    @Override
    protected void instrumentSource(IFile originalFile) throws CloverException, CoreException {
        this.maybeInitialiseInstrumentation();
        this.removeMarkers(originalFile);
        this.monitor.subTask("Instrumenting " + originalFile.getFullPath());
        CharArrayWriter out = new CharArrayWriter(2056);
        try {
            FileInstrumentationSource input = new FileInstrumentationSource(originalFile.getLocation().toFile(), originalFile.getCharset());
            this.instrumenter.instrument(input, out, originalFile.getCharset());
            this.originalToInstrumentedSource.put(originalFile.getLocation().toFile().getAbsolutePath(), out.toCharArray());
        }
        catch (Exception e) {
            this.addInstrumentationFailure(originalFile, e);
        }
        this.hasInstrumented = true;
        this.monitor.worked(1);
    }

    @Override
    public Iterator fileNamesAsCompilerArg() {
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = InMemoryInstrumenter.this.originalToInstrumentedSource.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next() + "[UTF-8]";
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void copySource(IFile originalFile) throws CloverException, CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public char[] getContentsFor(String filename) {
        return (char[])this.originalToInstrumentedSource.get(filename);
    }

    @Override
    public boolean willRenderContentsFor(String filename) {
        return this.originalToInstrumentedSource.containsKey(filename);
    }
}

