/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.BaseInstrumenter;
import org.openclover.eclipse.core.projects.builder.FileNameWithEncoding;
import org.openclover.eclipse.core.projects.builder.InstrumentationProjectPathMap;

public class FileBasedInstrumenter
extends BaseInstrumenter {
    protected final Map originalToInstrumentedFileAndEncoding = new LinkedHashMap();

    public FileBasedInstrumenter(CloverProject project, Clover2Registry registry, InstrumentationProjectPathMap pathMap, IProgressMonitor monitor, int buildKind) throws CoreException {
        super(monitor, pathMap, project, registry, buildKind);
    }

    @Override
    protected void copySource(IFile originalFile) throws CloverException, CoreException {
        IPath originalSourceRoot = this.instrumentationMapper.getOriginalSourceRootFor(originalFile.getFullPath());
        IPath instrumentedSourceRoot = this.instrumentationMapper.getDisplacedSourceRootFor(originalFile.getFullPath());
        IPath copyPath = instrumentedSourceRoot.append(originalFile.getFullPath().removeFirstSegments(originalSourceRoot.segmentCount()));
        File copiedFile = copyPath.toFile();
        copiedFile.getParentFile().mkdirs();
        try {
            FileUtils.fileCopy(originalFile.getLocation().toFile(), copiedFile);
        }
        catch (IOException e) {
            throw new CloverException("Unable to copy excluded source file for compilation", e);
        }
        this.originalToInstrumentedFileAndEncoding.put(originalFile, new FileNameWithEncoding(copiedFile.getAbsolutePath(), originalFile.getCharset()));
        this.monitor.worked(1);
    }

    @Override
    protected void instrumentSource(IFile originalFile) throws CloverException, CoreException {
        IPath instrumentedSourceRoot = this.instrumentationMapper.getDisplacedSourceRootFor(originalFile.getFullPath());
        if (instrumentedSourceRoot != null) {
            this.maybeInitialiseInstrumentation();
            this.removeMarkers(originalFile);
            this.monitor.subTask("Instrumenting " + originalFile.getFullPath());
            try {
                File instrumentedFile = this.instrumenter.instrument(originalFile.getLocation().toFile(), instrumentedSourceRoot.toFile(), originalFile.getCharset());
                FileNameWithEncoding fileNameWithEncoding = new FileNameWithEncoding(instrumentedFile.getAbsolutePath(), originalFile.getCharset());
                this.originalToInstrumentedFileAndEncoding.put(originalFile.getLocation().toFile().getAbsolutePath(), fileNameWithEncoding);
            }
            catch (CloverException e) {
                this.addInstrumentationFailure(originalFile, e);
            }
            this.hasInstrumented = true;
        }
        this.monitor.worked(1);
    }

    @Override
    public Iterator fileNamesAsCompilerArg() {
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = FileBasedInstrumenter.this.originalToInstrumentedFileAndEncoding.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                FileNameWithEncoding fnwi = (FileNameWithEncoding)this.iter.next();
                return fnwi.getFileName() + "[" + fnwi.getEncoding() + "]";
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean willRenderContentsFor(String filename) {
        return false;
    }
}

