/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.util.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.internal.compiler.batch.CloverCompiler;
import org.eclipse.swt.widgets.Display;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.BaseInstrumenter;
import org.openclover.eclipse.core.projects.builder.CleaningVisitor;
import org.openclover.eclipse.core.projects.builder.FileBasedInstrumenter;
import org.openclover.eclipse.core.projects.builder.InstrumentationException;
import org.openclover.eclipse.core.projects.builder.InstrumentationInitialisationException;
import org.openclover.eclipse.core.projects.builder.InstrumentationProjectPathMap;
import org.openclover.eclipse.core.projects.builder.JDTUtils;
import org.openclover.eclipse.core.projects.builder.PathUtils;
import org.openclover.eclipse.core.projects.builder.ProjectPathMap;
import org.openclover.eclipse.core.projects.model.CoverageFilesUtils;
import org.openclover.eclipse.core.projects.model.CoverageModelChangeEvent;
import org.openclover.eclipse.core.projects.model.DuringFullBuildDatabaseModel;
import org.openclover.eclipse.core.projects.model.LoadedDatabaseModel;
import org.openclover.eclipse.core.ui.widgets.MessageDialogWithCheckbox;
import org.openclover.util.Lists;
import org.osgi.framework.Version;

public class BuildCoordinator {
    private static final int TOTAL_COMPILATION_PROGRESS = 1000;
    private static final int INSTRUMENTATION_PROGRESS = 400;
    private static final int COMPILATION_PROGRESS = 400;
    private static final int REFRESHING_OUTPUT_LOCATION_PROGRESS = 100;
    private static final int REMOVING_WORK_AREA_PROGRESS = 100;
    protected final CloverProject project;

    public BuildCoordinator(CloverProject project) {
        this.project = project;
    }

    public void registerFilesForInstrumentation(BuildContext[] files) throws CoreException {
        if (files.length > 0) {
            Set<IFile> beingCompiled = this.project.getFilesNeedingCloverCompile();
            if (beingCompiled == null) {
                beingCompiled = new LinkedHashSet<IFile>();
                this.project.setFilesNeedingCloverCompile(beingCompiled);
            }
            for (BuildContext file : files) {
                beingCompiled.add(file.getFile());
            }
        }
    }

    private boolean isPreserveInstrumentedSources() {
        boolean preserve = CloverPlugin.getInstance().getInstallationSettings().isPreserveInstrumentedSources();
        CloverPlugin.logVerbose("Instrumented sources will " + (preserve ? "" : "not") + " be preserved in temporary directory.");
        return preserve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEndOfBuild(int buildKind, IProgressMonitor monitor) throws CoreException {
        Set<IFile> dirtyFiles = this.project.getFilesNeedingCloverCompile();
        monitor.beginTask("Compiling with Clover", 1000);
        try {
            if (this.shouldBuild(dirtyFiles)) {
                monitor.subTask("Waiting for Clover model to load");
                CloverDatabase database = this.project.joinOnLoad(monitor);
                if (database != null) {
                    if (this.shouldBuild(dirtyFiles) && this.isFullBuild(buildKind)) {
                        this.project.setModel(new DuringFullBuildDatabaseModel(this.project, CoverageModelChangeEvent.COMPILE(this.project)));
                        database = this.project.newEmptyDatabase();
                    } else if (database == null) {
                        database = this.project.newEmptyDatabase();
                    }
                    Clover2Registry registry = database.getRegistry();
                    final File workArea = this.createCompilationWorkArea();
                    Path workAreaPath = new Path(workArea.getAbsolutePath());
                    final InstrumentationProjectPathMap workAreaPathMap = new InstrumentationProjectPathMap(this.project, (IPath)workAreaPath);
                    final BaseInstrumenter instrumenter = this.instrument(registry, workAreaPathMap, dirtyFiles, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)400), buildKind);
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                BuildCoordinator.this.compile(workAreaPathMap, instrumenter, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)400));
                            }
                            finally {
                                if (BuildCoordinator.this.isPreserveInstrumentedSources()) {
                                    File copyArea = BuildCoordinator.this.createInstrSourcesCopyWorkArea();
                                    try {
                                        FileUtils.dirCopy(workArea, copyArea, false);
                                        CloverPlugin.logInfo("CLOVER: Instrumented sources have been preserved in " + copyArea.getAbsolutePath());
                                    }
                                    catch (IOException ex) {
                                        CloverPlugin.logInfo("CLOVER: Failed to copy instrumented sources from " + workArea.getAbsolutePath() + " to " + copyArea.getAbsolutePath());
                                    }
                                } else {
                                    CloverPlugin.logDebug("Removing instrumented sources from " + workArea.getAbsolutePath());
                                    BuildCoordinator.this.removeWorkArea(workArea, monitor);
                                }
                            }
                        }
                    }, monitor);
                    boolean includeFailedCoverage = CloverPlugin.getInstance().getInstallationSettings().isIncludeFailedCoverage();
                    this.project.setModel(new LoadedDatabaseModel(this.project, database, CoverageModelChangeEvent.COMPILE(this.project), includeFailedCoverage));
                }
            }
        }
        finally {
            monitor.done();
            this.project.clearFilesNeedingCloverCompile();
        }
    }

    private boolean shouldBuild(Set dirtyFiles) {
        return dirtyFiles != null && dirtyFiles.size() > 0;
    }

    private boolean isFullBuild(int buildKind) {
        return buildKind == 6;
    }

    private Clover2Registry createEmptyRegistry() {
        return new Clover2Registry(this.project.getRegistryFile(), this.project.getName());
    }

    private void refreshOutputLocations(IProgressMonitor monitor) throws CoreException {
        IContainer outputContainer;
        IPath[] outputPaths;
        monitor.subTask("Refreshing output folders");
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath outputPath : outputPaths = this.project.getPathMap().getAllOutputLocations()) {
            IResource outputLocation = workspaceRoot.findMember(outputPath);
            if (outputLocation == null || !(outputLocation instanceof IContainer)) continue;
            outputLocation.refreshLocal(2, monitor);
        }
        if (!this.project.getSettings().isOutputRootSameAsProject() && (outputContainer = PathUtils.containerFor(this.project.getProject().getFullPath().append(this.project.getSettings().getOutputRoot()))) != null && outputContainer.exists()) {
            outputContainer.refreshLocal(2, monitor);
        }
        monitor.worked(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseInstrumenter instrument(Clover2Registry registry, InstrumentationProjectPathMap workAreaPathMap, Set<IFile> filesNeedingCompile, IProgressMonitor monitor, int buildKind) throws CoreException {
        monitor.beginTask("Clover: Instrumenting project source", 10);
        try {
            if (filesNeedingCompile.size() > 0) {
                boolean successful = true;
                CloverPlugin.logVerbose("Starting instrumentation");
                long start = System.currentTimeMillis();
                FileBasedInstrumenter instrumenter = new FileBasedInstrumenter(this.project, registry, workAreaPathMap, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10), buildKind);
                instrumenter.start(filesNeedingCompile.size());
                for (IFile file : filesNeedingCompile) {
                    try {
                        if (monitor.isCanceled()) break;
                        instrumenter.instrumentOrCopySource(file);
                    }
                    catch (InstrumentationInitialisationException e) {
                        throw e;
                    }
                    catch (InstrumentationException e) {
                        CloverPlugin.logVerbose("Instrumenting file " + file + " failed, syntax error in original source?", (Throwable)((Object)e));
                        successful = false;
                    }
                }
                if (!monitor.isCanceled()) {
                    instrumenter.finish(successful);
                    CloverPlugin.logVerbose("Ending instrumentation, took " + (System.currentTimeMillis() - start) + "ms");
                    FileBasedInstrumenter fileBasedInstrumenter = instrumenter;
                    return fileBasedInstrumenter;
                }
            }
            BaseInstrumenter baseInstrumenter = null;
            return baseInstrumenter;
        }
        finally {
            monitor.done();
        }
    }

    private File createCompilationWorkArea() throws CoreException {
        try {
            File tempFolder = this.project.getWorkingPath().toFile();
            return FileUtils.createTempDir("CLOV", tempFolder);
        }
        catch (IOException e) {
            throw CloverPlugin.logAndThrowError("Unable to create working folder", e);
        }
    }

    private File createInstrSourcesCopyWorkArea() {
        File workDir = new File(this.project.getWorkingPath().toFile(), "CLOV_INSTR_SRC");
        workDir.mkdir();
        return workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(InstrumentationProjectPathMap workAreaPathMap, BaseInstrumenter instrumenter, IProgressMonitor monitor) throws CoreException {
        if (instrumenter != null && !monitor.isCanceled()) {
            monitor.subTask("Compiling Clover-instrumented source");
            CloverPlugin.logVerbose("Starting instrumented compilation");
            long start = System.currentTimeMillis();
            try {
                ArrayList<String> command = Lists.newArrayList();
                this.addOutputPathToClasspath(this.project.getJavaProject(), command);
                this.outputLibrariesToClasspath(command, this.collectClasspathEntries(new HashSet(), new LinkedHashSet(), this.project.getJavaProject(), false));
                this.addMiscParams(command);
                this.addTargetParam(command);
                this.addSourceParam(command);
                this.addNoWarningsFlag(command);
                this.addProceedOnErrorFlag(command);
                this.addEncodingParam(command);
                this.addSourceFilesToCompile(instrumenter, command);
                CloverPlugin.logVerbose("Running compilation command: " + command);
                File outFile = File.createTempFile("cloverCompilationLog", ".out");
                outFile.deleteOnExit();
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
                File errFile = File.createTempFile("cloverCompilationLog", ".err");
                errFile.deleteOnExit();
                PrintWriter err = new PrintWriter(new BufferedWriter(new FileWriter(errFile)));
                try {
                    if (!new CloverCompiler(out, err, instrumenter, workAreaPathMap, monitor).compile(command.toArray(new String[command.size()]))) {
                        CloverPlugin.logVerbose("Instrumented compilation returned false");
                        CloverPlugin.logVerbose("Instrumented compilation out: " + outFile.getAbsolutePath());
                        CloverPlugin.logVerbose("Instrumented compilation error: " + errFile.getAbsolutePath());
                    }
                }
                finally {
                    out.close();
                    err.close();
                }
            }
            catch (Exception e) {
                CloverPlugin.logError("Error compiling instrumented source", e);
            }
            CloverPlugin.logVerbose("Ending instrumented compilation, took " + (System.currentTimeMillis() - start) + "ms");
        } else {
            CloverPlugin.logVerbose("Not performing instrumented compilation - nothing to do or compilation cancelled");
        }
        monitor.worked(400);
    }

    private void addSourceFilesToCompile(BaseInstrumenter instrumenter, List<String> command) {
        Iterator iterator = instrumenter.fileNamesAsCompilerArg();
        while (iterator.hasNext()) {
            command.add((String)iterator.next());
        }
    }

    private void addEncodingParam(List<String> command) {
        command.add("-encoding ");
        command.add("UTF-8");
    }

    private void addProceedOnErrorFlag(List<String> command) {
        command.add("-proceedOnError");
    }

    private void addNoWarningsFlag(List<String> command) {
        command.add("-nowarn");
    }

    private void addSourceParam(List<String> command) throws CoreException {
        command.add("-source");
        command.add(this.project.getJavaProject().getOption("org.eclipse.jdt.core.compiler.source", true));
    }

    private void addTargetParam(List<String> command) throws CoreException {
        command.add("-target");
        command.add(this.project.getJavaProject().getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
    }

    private void addMiscParams(List<String> command) throws CoreException {
        LinkedList debugOptions = Lists.newLinkedList();
        if ("generate".equals(this.project.getJavaProject().getOption("org.eclipse.jdt.core.compiler.debug.lineNumber", true))) {
            debugOptions.add("lines");
        }
        if ("generate".equals(this.project.getJavaProject().getOption("org.eclipse.jdt.core.compiler.debug.localVariable", true))) {
            debugOptions.add("vars");
        }
        if ("generate".equals(this.project.getJavaProject().getOption("org.eclipse.jdt.core.compiler.debug.sourceFile", true))) {
            debugOptions.add("source");
        }
        StringBuilder debugSwitch = new StringBuilder("-g:");
        if (debugOptions.size() == 0) {
            debugSwitch.append("none");
        } else {
            Iterator iterator = debugOptions.iterator();
            while (iterator.hasNext()) {
                debugSwitch.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                debugSwitch.append(",");
            }
        }
        command.add(debugSwitch.toString());
        if ("preserve".equals(this.project.getJavaProject().getOption("org.eclipse.jdt.core.compiler.codegen.unusedLocal", true))) {
            command.add("-preserveAllLocals");
        }
        if ("enabled".equals(this.project.getJavaProject().getOption("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", true))) {
            command.add("-inlineJSR");
        }
        this.addVersionSpecificMiscParams(command);
    }

    private void addVersionSpecificMiscParams(List<String> command) throws CoreException {
        Version version = JDTUtils.getJDTVersion();
        if (version.getMajor() == 3 && version.getMinor() >= 3) {
            command.add("-proc:none");
        }
    }

    private Set collectClasspathEntries(Set projectSet, Set classpathEntries, IJavaProject currentProject, boolean checkExported) throws CoreException {
        IWorkspaceRoot root = currentProject.getProject().getWorkspace().getRoot();
        if (projectSet.add(currentProject)) {
            IClasspathEntry[] entries;
            for (IClasspathEntry entry : entries = currentProject.getResolvedClasspath(true)) {
                IJavaProject dependentJavaProject;
                IProject dependentProject;
                if (entry.getEntryKind() == 1) {
                    if ((!checkExported || !entry.isExported()) && checkExported) continue;
                    IPath absolutePath = entry.getPath();
                    IResource resource = root.findMember(entry.getPath());
                    if (resource == null || !resource.exists()) {
                        resource = currentProject.getProject().findMember(entry.getPath());
                    }
                    absolutePath = resource != null && resource.exists() ? resource.getLocation() : absolutePath;
                    classpathEntries.add(absolutePath.toOSString());
                    continue;
                }
                if (entry.getEntryKind() != 2 || !(dependentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())).exists() || !dependentProject.isAccessible() || (dependentJavaProject = JavaCore.create((IProject)dependentProject)) == null) continue;
                classpathEntries.addAll(new ProjectPathMap(dependentJavaProject).getOutputLocations());
                this.collectClasspathEntries(projectSet, classpathEntries, dependentJavaProject, true);
            }
        }
        return classpathEntries;
    }

    private void outputLibrariesToClasspath(List<String> command, Set<String> libraries) throws CoreException {
        if (libraries.size() > 0) {
            for (String library : libraries) {
                if (command.size() == 0) {
                    command.add("-bootclasspath");
                    command.add(library);
                    continue;
                }
                this.appendToLast(command, File.pathSeparatorChar + library);
            }
        }
    }

    private void addOutputPathToClasspath(ProjectPathMap projectPathMap, List<String> command) throws CoreException {
        String outputClasspath = projectPathMap.toClasspath();
        if (outputClasspath.length() > 0) {
            if (command.size() == 0) {
                command.add("-bootclasspath");
                command.add(outputClasspath);
            } else {
                this.appendToLast(command, File.pathSeparatorChar + outputClasspath);
            }
        }
    }

    private void appendToLast(List<String> command, String value) {
        command.set(command.size() - 1, command.get(command.size() - 1) + value);
    }

    private void addOutputPathToClasspath(IJavaProject project, List<String> command) throws CoreException {
        this.addOutputPathToClasspath(new ProjectPathMap(project), command);
    }

    private void removeWorkArea(File lastCompilationDir, IProgressMonitor monitor) {
        CloverPlugin.logDebug("Deleting class files in " + lastCompilationDir);
        lastCompilationDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    file.listFiles(this);
                    file.delete();
                    return false;
                }
                if (file.isFile()) {
                    file.delete();
                }
                return true;
            }
        });
        lastCompilationDir.delete();
        monitor.worked(100);
    }

    public void onClean(IProgressMonitor monitor) {
        boolean shouldClearCoverage;
        boolean includeFailedCoverage = CloverPlugin.getInstance().getInstallationSettings().isIncludeFailedCoverage();
        this.project.setModel(new LoadedDatabaseModel(this.project, this.project.newEmptyDatabase(), CoverageModelChangeEvent.COMPILE(this.project), includeFailedCoverage));
        this.project.setLastCleanBuildStamp(System.currentTimeMillis());
        if (CloverPlugin.getInstance().getInstallationSettings().isPromptingOnRebuild()) {
            final MessageDialogWithCheckbox.Result result = new MessageDialogWithCheckbox.Result();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithCheckbox.openQuestion(null, "Delete existing Clover coverage data?", "You are doing a rebuild, do you want delete the old coverage data for project \"" + BuildCoordinator.this.project.getName() + "\"?", true, "Display this prompt again?", true, result);
                }
            });
            shouldClearCoverage = result.isYesSelected();
            CloverPlugin.getInstance().getInstallationSettings().setLatestPromptOnRebuildDecision(result.isYesSelected());
            CloverPlugin.getInstance().getInstallationSettings().setPromptingOnRebuild(result.isChecked());
        } else {
            shouldClearCoverage = CloverPlugin.getInstance().getInstallationSettings().isDeletingCoverageOnRebuild();
        }
        this.nukeCoverageData(shouldClearCoverage, monitor);
        this.nukeSeparateInstrumentedClasses(monitor);
    }

    private void nukeSeparateInstrumentedClasses(final IProgressMonitor monitor) {
        try {
            final IFolder instrumentationOutput = this.project.getInstrumentationOutputRootDir();
            if (instrumentationOutput != null && instrumentationOutput.exists()) {
                this.project.runOnWorkingDir(new CloverProject.Callable(){

                    @Override
                    public void call() throws CoreException {
                        instrumentationOutput.refreshLocal(2, monitor);
                        instrumentationOutput.accept((IResourceVisitor)new CleaningVisitor(instrumentationOutput, monitor));
                    }
                });
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to clean Clover output directory", e);
        }
    }

    private void nukeCoverageData(boolean shouldClearCoverage, IProgressMonitor monitor) {
        if (shouldClearCoverage) {
            CloverPlugin.logVerbose("Clearing coverage information");
            CoverageFilesUtils.deleteCoverageFiles(this.project.getRegistryFile(), true, monitor);
        }
    }
}

