/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.launching.actions;

import java.util.Map;
import org.eclipse.debug.ui.actions.ContextualLaunchAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.openclover.eclipse.core.ui.CloverPluginIcons;
import org.openclover.util.Maps;

public class ContextualRunWithCloverAction
extends ContextualLaunchAction {
    private ResourceManager imageManager = new LocalResourceManager(JFaceResources.getResources());
    private Map<String, Image> images = Maps.newHashMap();

    public ContextualRunWithCloverAction() {
        super("clover");
        this.addImageForShortcutCommand("org.openclover.eclipse.core.launching.LocalJavaApplicationShortcut.clover", "org.eclipse.jdt.debug.ui", "icons/full/etool16/java_app.gif");
        this.addImageForShortcutCommand("org.openclover.eclipse.core.launching.LocalJavaAppletShortcut.clover", "org.eclipse.jdt.debug.ui", "icons/full/etool16/java_applet.gif");
        this.addImageForShortcutCommand("org.openclover.eclipse.core.launching.WorkbenchPDEShortcut.clover", "org.eclipse.pde.ui", "icons/obj16/eclipse.gif");
        this.addImageForShortcutCommand("org.openclover.eclipse.core.launching.JUnitShortcut.clover", "org.eclipse.jdt.junit", "icons/full/obj16/julaunch.gif");
        this.addImageForShortcutCommand("org.openclover.eclipse.core.launching.JUnitPDEShortcut.clover", "org.eclipse.pde.ui", "icons/obj16/julaunchpgn.gif");
    }

    private void addImageForShortcutCommand(String name, String bundleName, String resourcePath) {
        Image image = CloverPluginIcons.grabPluginImage(this.imageManager, bundleName, resourcePath);
        if (image != null) {
            this.images.put(name, image);
        }
    }

    public void dispose() {
        super.dispose();
        this.imageManager.dispose();
        this.images.clear();
    }

    protected void fillMenu(Menu menu) {
        MenuItem[] items;
        super.fillMenu(menu);
        for (MenuItem item : items = menu.getItems()) {
            String commandId;
            if (!(item.getData() instanceof ActionContributionItem) || !this.images.containsKey(commandId = ((ActionContributionItem)item.getData()).getAction().getActionDefinitionId())) continue;
            item.setImage(this.images.get(commandId));
        }
    }
}

