/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.exclusion;

import com.atlassian.clover.util.FilterUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.openclover.eclipse.core.exclusion.ICloverExcludable;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;
import org.openclover.util.Lists;

public class ExclusionUtil {
    private static final String[] FLYWEIGHT = new String[0];

    private ExclusionUtil() {
    }

    public static boolean isPresent(ICloverExcludable excludable, boolean inExcludes) {
        try {
            CloverProject cloverProject = CloverProject.getFor(excludable.getProject());
            return cloverProject != null && ExclusionUtil.isPresent(excludable, inExcludes, cloverProject.getSettings().isInstrumentSelectedSourceFolders());
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isPresent(ICloverExcludable excludable, boolean inExcludes, boolean sourceRootBased) {
        String pattern = ExclusionUtil.createPattern(excludable, sourceRootBased);
        for (String existing : ExclusionUtil.getExistingPatterns(excludable, inExcludes)) {
            if (!pattern.equals(existing)) continue;
            return true;
        }
        return false;
    }

    private static String createPattern(ICloverExcludable excludable, boolean sourceRootBased) {
        return (!sourceRootBased ? excludable.getPackageFragmentRoot().getResource().getProjectRelativePath().toString() + "/" : "") + (excludable.isLeaf() ? excludable.getPath() : excludable.getPath() + "**");
    }

    public static boolean togglePresence(ICloverExcludable excludable, boolean inExcludes, boolean sourceRootBased) {
        String pattern = ExclusionUtil.createPattern(excludable, sourceRootBased);
        ProjectSettings settings = ExclusionUtil.getCloverProjectSettings(excludable);
        if (settings == null) {
            return false;
        }
        if (settings.isInstrumentSelectedSourceFolders()) {
            String srcPath = excludable.getPackageFragmentRoot().getResource().getProjectRelativePath().toString();
            List<SourceFolderPattern> instrumentedFolderPatterns = settings.getInstrumentedFolderPatterns();
            ArrayList<SourceFolderPattern> newFolderPatterns = new ArrayList<SourceFolderPattern>(instrumentedFolderPatterns.size());
            for (SourceFolderPattern sfp : instrumentedFolderPatterns) {
                if (srcPath.equals(sfp.getSrcPath())) {
                    String existingPatterns = inExcludes ? sfp.getExcludePattern() : sfp.getIncludePattern();
                    String newPattern = ExclusionUtil.toggleString(existingPatterns, pattern);
                    SourceFolderPattern newSFP = new SourceFolderPattern(sfp.getSrcPath(), inExcludes ? sfp.getIncludePattern() : newPattern, inExcludes ? newPattern : sfp.getExcludePattern(), sfp.isEnabled());
                    newFolderPatterns.add(newSFP);
                    continue;
                }
                newFolderPatterns.add(sfp);
            }
            settings.setInstrumentedFolderPatterns(newFolderPatterns);
        } else {
            String newPattern;
            String existingPatterns = inExcludes ? settings.getExcludeFilter() : settings.getIncludeFilter();
            String string = newPattern = existingPatterns != null ? ExclusionUtil.toggleString(existingPatterns, pattern) : pattern;
            if (inExcludes) {
                settings.setExcludeFilter(newPattern);
            } else {
                settings.setIncludeFilter(newPattern);
                return existingPatterns == null || existingPatterns.length() == 0 || newPattern.length() == 0;
            }
        }
        return false;
    }

    static String toggleString(String origPatterns, String pattern) {
        ArrayList<String> patterns = Lists.newArrayList(FilterUtils.tokenizePattern(origPatterns));
        if (patterns.remove(pattern)) {
            StringBuilder sb = new StringBuilder(origPatterns.length());
            String separator = "";
            for (String s : patterns) {
                sb.append(separator);
                sb.append(s);
                separator = ", ";
            }
            return sb.toString();
        }
        return origPatterns.trim().length() == 0 ? pattern : origPatterns + ", " + pattern;
    }

    private static String[] getExistingPatterns(ICloverExcludable excludable, boolean inExcludes) {
        String patterns;
        block3: {
            ProjectSettings settings = ExclusionUtil.getCloverProjectSettings(excludable);
            if (settings == null) {
                return FLYWEIGHT;
            }
            if (settings.isInstrumentSelectedSourceFolders()) {
                String srcPath = excludable.getPackageFragmentRoot().getResource().getProjectRelativePath().toString();
                for (SourceFolderPattern sfp : settings.getInstrumentedFolderPatterns()) {
                    if (!srcPath.equals(sfp.getSrcPath())) continue;
                    patterns = inExcludes ? sfp.getExcludePattern() : sfp.getIncludePattern();
                    break block3;
                }
                return FLYWEIGHT;
            }
            patterns = inExcludes ? settings.getExcludeFilter() : settings.getIncludeFilter();
        }
        return patterns != null ? FilterUtils.tokenizePattern(patterns) : FLYWEIGHT;
    }

    private static ProjectSettings getCloverProjectSettings(ICloverExcludable excludable) {
        try {
            CloverProject cloverProject = CloverProject.getFor(excludable.getProject());
            return cloverProject == null ? null : cloverProject.getSettings();
        }
        catch (CoreException e) {
            return null;
        }
    }
}

