/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core;

import com.atlassian.clover.Logger;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.openclover.eclipse.core.PluginLoggingAdapter;
import org.openclover.eclipse.core.SystemJob;
import org.openclover.eclipse.core.exclusion.ExclusionLabelDecorator;
import org.openclover.eclipse.core.projects.model.CoverageModelsMonitor;
import org.openclover.eclipse.core.reports.model.ReportHistoryEntry;
import org.openclover.eclipse.core.settings.InstallationSettings;
import org.openclover.eclipse.core.settings.WorkspaceSettings;
import org.openclover.eclipse.core.ui.editors.java.EditorCoverageSynchronizer;
import org.openclover.eclipse.core.ui.workingset.CloverWorkingSet;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CloverPlugin
extends AbstractUIPlugin {
    private static final long STARTUP_BACKOFF_DELAY = 10000L;
    public static final String ID = "org.openclover.eclipse.core";
    public static final IPath CLOVER_RUNTIME_VARIABLE = new Path("CLOVER_RUNTIME");
    public static CloverPlugin instance;
    private BundleListener startListener;
    private PluginLoggingAdapter cloverLogger = new PluginLoggingAdapter(this.getLog(), false);
    private CoverageModelsMonitor coverageMonitor;
    private EditorCoverageSynchronizer editorSynchronizer;
    private CloverWorkingSet workingSet;
    private List customColumns;
    private InstallationSettings installationSettings;
    private WorkspaceSettings workspaceSettings;

    public static CloverPlugin getInstance() {
        return instance;
    }

    public static boolean isLoggingDebugFor(String category) {
        return CloverPlugin.getInstance().isDebugging() && CloverPlugin.getInstance().debugPlatformOptionOn(category);
    }

    public static void logVerbose(String message) {
        CloverPlugin.getInstance().cloverLogger.verbose(message);
    }

    public static void logVerbose(String message, Throwable t) {
        CloverPlugin.getInstance().cloverLogger.verbose(message, t);
    }

    public static void logDebug(String message) {
        CloverPlugin.getInstance().cloverLogger.debug(message);
    }

    public static void logDebug(String message, Throwable t) {
        CloverPlugin.getInstance().cloverLogger.debug(message, t);
    }

    public static void logInfo(String message) {
        CloverPlugin.getInstance().cloverLogger.info(message);
    }

    public static void logInfo(String message, Throwable t) {
        CloverPlugin.getInstance().cloverLogger.info(message, t);
    }

    public static void logWarning(String message) {
        CloverPlugin.getInstance().cloverLogger.warn(message);
    }

    public static void logWarning(String message, Throwable t) {
        CloverPlugin.getInstance().cloverLogger.warn(message, t);
    }

    public static CoreException logAndThrowError(String message) {
        CloverPlugin.logError(message);
        return new CoreException((IStatus)new Status(4, ID, 0, message, null));
    }

    public static CoreException logAndThrowError(String message, Throwable t) {
        CloverPlugin.logError(message, t);
        return new CoreException((IStatus)new Status(4, ID, 0, message, t));
    }

    public static void logError(String message) {
        CloverPlugin.getInstance().cloverLogger.error(message);
    }

    public static void logError(String message, Throwable t) {
        CloverPlugin.getInstance().cloverLogger.error(message, t);
    }

    public CloverPlugin() {
        Logger.setInstance(this.cloverLogger);
        instance = this;
        CloverPlugin.logInfo("Clover plugin constructed");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.buildSettings();
        this.ensureInstallDateGenerated();
        this.setLoggingLevel(this.getInstallationSettings().getLoggingLevel());
        this.loadCustomColumns();
        this.buildWorkingSet();
        this.editorSynchronizer = new EditorCoverageSynchronizer(this.getWorkbench());
        this.coverageMonitor = new CoverageModelsMonitor();
        final long thisBundleId = context.getBundle().getBundleId();
        this.startListener = new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                if (bundleEvent.getBundle().getBundleId() == thisBundleId && bundleEvent.getType() == 2) {
                    new SystemJob("Clover background processing starter"){

                        protected IStatus run(IProgressMonitor progressMonitor) {
                            try {
                                CloverPlugin.this.startMonitorEditors();
                                CloverPlugin.this.startMonitoringCoverage();
                                CloverPlugin.this.listenForSettingsChanges();
                            }
                            catch (Exception e) {
                                CloverPlugin.logError("Failed to start background processing", e);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule(10000L);
                }
            }
        };
        context.addBundleListener(this.startListener);
        CloverPlugin.logInfo("Clover plugin started");
    }

    private void startMonitoringCoverage() {
        this.coverageMonitor.start();
    }

    private void startMonitorEditors() {
        this.editorSynchronizer.syncWithCoverageSetting(this.installationSettings.getEditorCoverageStyle());
    }

    private void buildWorkingSet() {
        this.workingSet = new CloverWorkingSet(this.getWorkbench().getWorkingSetManager());
    }

    private void listenForSettingsChanges() {
        this.installationSettings.addListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String propertyName = event.getKey();
                if ("logging_level".equals(propertyName)) {
                    CloverPlugin.this.setLoggingLevel(event.getNewValue() != null ? (String)event.getNewValue() : CloverPlugin.this.getInstallationSettings().getLoggingLevel());
                } else if ("coverage_style_in_editors".equals(propertyName)) {
                    try {
                        CloverPlugin.this.editorSynchronizer.syncWithCoverageSetting(Integer.parseInt((String)event.getNewValue()));
                    }
                    catch (ClassCastException e) {
                        CloverPlugin.logError("Coverage style setting invalid type: " + event.getNewValue().getClass().getName());
                    }
                    catch (NumberFormatException e) {
                        CloverPlugin.logError("Coverage style setting invalid integer string: " + event.getNewValue());
                    }
                } else if ("show_exclusion_annotations".equals(propertyName)) {
                    ExclusionLabelDecorator.decorationChanged();
                }
            }
        });
    }

    private void loadCustomColumns() {
        this.customColumns = this.installationSettings.getCustomColumns();
    }

    private void buildSettings() {
        this.installationSettings = new InstallationSettings();
        this.workspaceSettings = new WorkspaceSettings();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.startListener != null) {
                context.removeBundleListener(this.startListener);
            }
            this.editorSynchronizer.dispose();
            this.coverageMonitor.stop();
            this.installationSettings.save();
            this.workspaceSettings.save();
        }
        finally {
            super.stop(context);
            this.cloverLogger.info("Clover plugin stopped");
        }
    }

    private String prefixed(String key) {
        return "org.openclover.eclipse.core.preferences." + key;
    }

    private void ensureInstallDateGenerated() {
        long installDate = this.getInstallationSettings().getInstallDate();
        if (installDate == -1L) {
            installDate = System.currentTimeMillis();
            CloverPlugin.logInfo("Setting installation date for this product to " + installDate);
            this.getInstallationSettings().setInstallDate(installDate);
        }
    }

    public InstallationSettings getInstallationSettings() {
        return this.installationSettings;
    }

    public PluginLoggingAdapter getCloverLogger() {
        return this.cloverLogger;
    }

    private void setLoggingLevel(String propertyValue) {
        if ("none".equals(propertyValue)) {
            this.cloverLogger.setEnabled(false);
        } else {
            boolean verbose;
            boolean debug;
            if ("debug".equals(propertyValue)) {
                debug = true;
                verbose = true;
            } else if ("verbose".equals(propertyValue)) {
                debug = false;
                verbose = true;
            } else {
                debug = false;
                verbose = false;
            }
            super.setDebugging(debug);
            Logger.setDebug(debug);
            Logger.setVerbose(verbose);
            this.cloverLogger.setEnabled(true);
            this.cloverLogger.info("Setting logging level: debug=" + debug + " verbose=" + verbose);
        }
    }

    public boolean debugPlatformOptionOn(String category) {
        return "true".equalsIgnoreCase(Platform.getDebugOption((String)(ID + (category == null ? "" : "/" + category) + "/debug")));
    }

    public String getPluginOption(String option) {
        return Platform.getDebugOption((String)("org.openclover.eclipse.core/" + option));
    }

    public List<ReportHistoryEntry> getReportHistory() {
        try {
            Preferences instancePrefs = Platform.getPreferencesService().getRootNode().node("instance").node(ID);
            int historyCount = instancePrefs.getInt("report_history_count", 0);
            LinkedList<ReportHistoryEntry> history = Lists.newLinkedList();
            for (int i = 0; i < historyCount; ++i) {
                if (!instancePrefs.nodeExists("report_history_" + i)) continue;
                history.add(new ReportHistoryEntry(instancePrefs.node("report_history_" + i)));
            }
            return history;
        }
        catch (BackingStoreException e) {
            return Collections.emptyList();
        }
    }

    private void setReportHistory(List<ReportHistoryEntry> history) {
        HashMap pathToHistory = Maps.newHashMap();
        for (ReportHistoryEntry report : history) {
            if (!report.isValid()) continue;
            pathToHistory.put(report.getPath(), report);
        }
        List<ReportHistoryEntry> savedHistory = Lists.newLinkedList(history);
        history.retainAll(pathToHistory.values());
        savedHistory = savedHistory.subList(Math.max(0, savedHistory.size() - 5), savedHistory.size());
        Preferences instancePrefs = Platform.getPreferencesService().getRootNode().node("instance").node(ID);
        int nodeCount = 0;
        for (ReportHistoryEntry entry : savedHistory) {
            entry.saveTo(instancePrefs.node("report_history_" + nodeCount++));
        }
        instancePrefs.putInt("report_history_count", nodeCount);
    }

    public void addReportToHistory(final ReportHistoryEntry report) {
        this.setReportHistory((List<ReportHistoryEntry>)new LinkedList<ReportHistoryEntry>(this.getReportHistory()){
            {
                super(x0);
                this.add(report);
            }
        });
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static Image getImage(String path) {
        ImageRegistry reg = CloverPlugin.getInstance().getImageRegistry();
        if (reg.getDescriptor(path) == null) {
            reg.put(path, ImageDescriptor.createFromURL((URL)instance.getBundle().getEntry(path)));
        }
        return reg.get(path);
    }

    public CoverageModelsMonitor getCoverageMonitor() {
        return this.coverageMonitor;
    }

    public boolean isInWorkingSetMode() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ID);
        return prefs.getBoolean("working_set_enabled", false);
    }

    public void setIsInWorkingSetMode(boolean enabled) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ID);
        prefs.putBoolean("working_set_enabled", enabled);
        prefs.flush();
        this.getCoverageMonitor().fireCoverageChange();
    }

    public CloverWorkingSet getCloverWorkingSet() {
        return this.workingSet;
    }

    public void showViews(IWorkbenchPage page) throws PartInitException {
        if (page.findView("org.openclover.eclipse.core.views.CloverView") == null) {
            page.showView("org.openclover.eclipse.core.views.CloverView");
        }
        if (page.findView("org.openclover.eclipse.core.views.testrunexplorer") == null) {
            page.showView("org.openclover.eclipse.core.views.testrunexplorer");
        }
        if (page.findView("org.openclover.eclipse.core.views.testcontributions") == null) {
            page.showView("org.openclover.eclipse.core.views.testcontributions");
        }
        if (page.findView("org.openclover.eclipse.core.views.dashboard") == null) {
            page.showView("org.openclover.eclipse.core.views.dashboard");
        }
    }

    public Version getJDTVersion() {
        try {
            Bundle jdtCore = Platform.getBundle((String)"org.eclipse.jdt.core");
            String versionString = jdtCore == null ? null : (String)jdtCore.getHeaders().get("Bundle-Version");
            return versionString == null ? null : Version.parseVersion((String)versionString);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to calculate JDT version", e);
            return null;
        }
    }
}

