/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ClassFilePool;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.builder.BaseInstrumenter;
import org.openclover.eclipse.core.projects.builder.InstrumentationProjectPathMap;
import org.openclover.eclipse.core.projects.builder.PathUtils;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class CloverCompiler
extends Main {
    private static final String RECORDER_CLASS_INTERFIX = "$__CLR";
    private static final int CLASSFILE_BUFFER_SIZE = 4096;
    private static final ReleaseInvoker RELEASE_INVOKER;
    private final BaseInstrumenter instrumenter;
    private final InstrumentationProjectPathMap pathMap;
    private final IProgressMonitor monitor;
    private final Map<IContainer, Set<String>> dirsToRecorderClassNames;
    private final Map<IContainer, Set<String>> dirsToRecorderClassBaseNames;

    public CloverCompiler(PrintWriter out, PrintWriter err, BaseInstrumenter instrumenter, InstrumentationProjectPathMap pathMap, IProgressMonitor monitor) {
        super(out, err, false, null, null);
        this.instrumenter = instrumenter;
        this.pathMap = pathMap;
        this.monitor = monitor;
        this.dirsToRecorderClassNames = Maps.newHashMap();
        this.dirsToRecorderClassBaseNames = Maps.newHashMap();
    }

    public boolean compile(String[] strings) {
        boolean result = super.compile(strings);
        try {
            this.removeOldRecorderClasses();
        }
        catch (CoreException e) {
            CloverPlugin.logError("Failed removing some old recorder classes", e);
        }
        return result;
    }

    public void outputClassFiles(CompilationResult unitResult) {
        if (!(unitResult == null || unitResult.hasErrors() && !this.proceedOnError || this.monitor.isCanceled())) {
            try {
                ClassFile[] classFiles = unitResult.getClassFiles();
                CompilationUnit compilationUnit = (CompilationUnit)unitResult.compilationUnit;
                String cuFileName = new String(compilationUnit.getFileName());
                IPath destinationPath = this.pathMap.getOutputRootForWorkignAreaSourceResource((IPath)new Path(cuFileName));
                IContainer currentDestination = this.ensureOutputContainerCreated(destinationPath);
                if (currentDestination != null && currentDestination instanceof IContainer) {
                    for (ClassFile classFile : classFiles) {
                        String baseName = new String(classFile.fileName()).replace('/', File.separatorChar);
                        String classFileName = baseName + ".class";
                        try {
                            this.writeToDisk(currentDestination, classFileName, classFile);
                            RELEASE_INVOKER.release(this, classFile);
                        }
                        catch (IOException e) {
                            CloverPlugin.logError("Unable to write class for file " + classFileName, e);
                        }
                    }
                } else {
                    CloverPlugin.logError("Unable to write class file as container " + (destinationPath == null ? "" : " " + destinationPath.toOSString() + " ") + "doesn't exist");
                }
            }
            catch (Exception e) {
                CloverPlugin.logError("Unable to write classes for source file " + new String(unitResult.getFileName()), e);
            }
        }
    }

    public CompilationUnit[] getCompilationUnits() {
        CompilationUnit[] result = null;
        try {
            result = super.getCompilationUnits();
            for (int i = 0; i < result.length; ++i) {
                String filename = new String(result[i].getFileName());
                if (!this.instrumenter.willRenderContentsFor(filename)) continue;
                final char[] customContents = this.instrumenter.getContentsFor(filename);
                result[i] = new CompilationUnit(null, this.filenames[i], "UTF-8"){

                    public char[] getContents() {
                        return customContents;
                    }
                };
            }
        }
        catch (Exception ex) {
            CloverPlugin.logError("Exception caught: " + ex);
        }
        return result;
    }

    private IContainer ensureOutputContainerCreated(IPath workspaceRelativePath) {
        try {
            IContainer container = PathUtils.containerFor(workspaceRelativePath);
            if (container instanceof IProject) {
                return container;
            }
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativePath);
            if (folder != null) {
                return (IFolder)PathUtils.makeDerivedFoldersFor((IResource)folder);
            }
            CloverPlugin.logError("Unable to create output folder " + workspaceRelativePath);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to create output folder " + workspaceRelativePath, e);
        }
        return null;
    }

    private boolean isRecorderClass(String baseName) {
        return baseName.contains(RECORDER_CLASS_INTERFIX);
    }

    private void removeOldRecorderClasses() throws CoreException {
        for (Map.Entry<IContainer, Set<String>> entry : this.dirsToRecorderClassNames.entrySet()) {
            final IContainer container = entry.getKey();
            final Set<String> newRecorderClasses = entry.getValue();
            container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    Set recorderBaseClasses;
                    String name;
                    if ((proxy.getType() == 2 || proxy.getType() == 4) && proxy.getName().equals(container.getName())) {
                        return true;
                    }
                    if (proxy.getType() == 1 && (name = proxy.getName()).indexOf(CloverCompiler.RECORDER_CLASS_INTERFIX) > 0 && !newRecorderClasses.contains(name) && (recorderBaseClasses = (Set)CloverCompiler.this.dirsToRecorderClassBaseNames.get(container)) != null) {
                        for (String recorderBaseClass : recorderBaseClasses) {
                            if (name.indexOf(recorderBaseClass) != 0) continue;
                            proxy.requestResource().delete(true, null);
                            break;
                        }
                    }
                    return false;
                }
            }, 1);
        }
    }

    private void writeToDisk(IContainer outputRoot, String packageFileName, ClassFile classFile) throws IOException, CoreException {
        IFile file = outputRoot.getFile((IPath)new Path(packageFileName));
        boolean isRecorder = this.isRecorderClass(file.getName());
        if (isRecorder) {
            this.registerRecorderClass(file);
        }
        if (!file.getParent().exists()) {
            PathUtils.makeFoldersFor((IResource)file);
        }
        long timestamp = System.currentTimeMillis();
        if (!file.exists()) {
            this.writeClassToFile(file, true, classFile, isRecorder);
        } else {
            timestamp = file.getLocalTimeStamp();
            this.writeClassToFile(file, false, classFile, isRecorder);
        }
        file.setLocalTimeStamp(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClassToFile(IFile file, boolean create, ClassFile classFile, boolean isRecorder) throws IOException, CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        BufferedOutputStream bos = new BufferedOutputStream(baos, 4096);
        try {
            if (isRecorder) {
                this.writeRawClassTo(classFile, baos);
            } else {
                this.writeSanitisedClassTo(classFile, baos);
            }
            bos.flush();
            if (create) {
                file.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
            }
        }
        finally {
            baos.close();
        }
    }

    private OutputStream writeRawClassTo(ClassFile classFile, OutputStream os) throws IOException {
        os.write(classFile.header, 0, classFile.headerOffset);
        os.write(classFile.contents, 0, classFile.contentsOffset);
        return os;
    }

    private void writeSanitisedClassTo(ClassFile classFile, OutputStream os) throws IOException {
        os.write(this.removeCloverInnerClassReferece(((ByteArrayOutputStream)this.writeRawClassTo(classFile, new ByteArrayOutputStream(4096))).toByteArray()));
    }

    private void registerRecorderClass(IFile file) {
        this.registerRecorderName(file);
        this.registerRecorderBaseNames(file);
    }

    private void registerRecorderBaseNames(IFile file) {
        Set<String> recorderBaseNames = this.dirsToRecorderClassBaseNames.get(file.getParent());
        if (recorderBaseNames == null) {
            recorderBaseNames = Sets.newHashSet();
            this.dirsToRecorderClassBaseNames.put(file.getParent(), recorderBaseNames);
        }
        recorderBaseNames.add(file.getName().substring(0, file.getName().indexOf(RECORDER_CLASS_INTERFIX) + RECORDER_CLASS_INTERFIX.length()));
    }

    private void registerRecorderName(IFile file) {
        Set<String> recorderNames = this.dirsToRecorderClassNames.get(file.getParent());
        if (recorderNames == null) {
            recorderNames = Sets.newHashSet();
            this.dirsToRecorderClassNames.put(file.getParent(), recorderNames);
        }
        recorderNames.add(file.getName());
    }

    public byte[] removeCloverInnerClassReferece(byte[] classBytes) throws IOException {
        ClassReader reader = new ClassReader(new ByteArrayInputStream(classBytes));
        ClassWriter writer = new ClassWriter(0);
        reader.accept(new RecorderInnerClassRemover(327680, writer), 0);
        return writer.toByteArray();
    }

    private String classBaseNameOf(String fileName) {
        return fileName.substring(0, fileName.indexOf(RECORDER_CLASS_INTERFIX) + RECORDER_CLASS_INTERFIX.length());
    }

    static {
        ReleaseInvoker invoker = ReleaseInvoker.UNAVAILABLE;
        try {
            invoker = new ReflectionReleaseInvoker();
        }
        catch (Throwable t) {
            CloverPlugin.logError("Unable to release any classes from the pool during compilation", t);
        }
        RELEASE_INVOKER = invoker;
    }

    public static class RecorderInnerClassRemover
    extends ClassVisitor {
        public RecorderInnerClassRemover(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (!name.contains("__CLR4_5_0")) {
                super.visitInnerClass(name, outerName, innerName, access);
            }
        }
    }

    private static class ReflectionReleaseInvoker
    implements ReleaseInvoker {
        private Field ClassFile_isShared = ClassFile.class.getDeclaredField("isShared");
        private Field Main_batchCompiler;
        private Field Compiler_lookupEnvironment;
        private Field LookupEnvironment_classFilePool;
        private Method ClassFilePool_release;

        private ReflectionReleaseInvoker() throws NoSuchMethodException, NoSuchFieldException {
            this.ClassFile_isShared.setAccessible(true);
            this.Main_batchCompiler = Main.class.getDeclaredField("batchCompiler");
            this.Main_batchCompiler.setAccessible(true);
            this.Compiler_lookupEnvironment = Compiler.class.getDeclaredField("lookupEnvironment");
            this.Compiler_lookupEnvironment.setAccessible(true);
            this.LookupEnvironment_classFilePool = LookupEnvironment.class.getDeclaredField("classFilePool");
            this.LookupEnvironment_classFilePool.setAccessible(true);
            this.ClassFilePool_release = ClassFilePool.class.getDeclaredMethod("release", ClassFile.class);
            this.ClassFilePool_release.setAccessible(true);
        }

        @Override
        public void release(CloverCompiler compiler, ClassFile classFile) {
            try {
                if (this.ClassFile_isShared.getBoolean(classFile)) {
                    Object batchCompiler = this.Main_batchCompiler.get((Object)compiler);
                    Object lookupEnvironment = this.Compiler_lookupEnvironment.get(batchCompiler);
                    Object classFilePool = this.LookupEnvironment_classFilePool.get(lookupEnvironment);
                    this.ClassFilePool_release.invoke(classFilePool, classFile);
                }
            }
            catch (Throwable e) {
                CloverPlugin.logError("Unable to release class " + classFile + " from pool", e);
            }
        }
    }

    private static interface ReleaseInvoker {
        public static final ReleaseInvoker UNAVAILABLE = new ReleaseInvoker(){

            @Override
            public void release(CloverCompiler compiler, ClassFile classFile) {
            }
        };

        public void release(CloverCompiler var1, ClassFile var2);
    }
}

