/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.ktreemap.example;

import net.sf.jtreemap.ktreemap.ITreeMapColorProvider;
import net.sf.jtreemap.ktreemap.ITreeMapProvider;
import net.sf.jtreemap.ktreemap.KTreeMap;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import net.sf.jtreemap.ktreemap.example.ResourceManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class HSBTreeMapColorProvider
implements ITreeMapColorProvider {
    protected KTreeMap m_jTreeMap;
    protected double m_maxValue = Double.MIN_VALUE;
    protected double m_minValue = Double.MAX_VALUE;
    private float m_positiveHue;
    private float m_negativeHue;
    private float m_positiveSaturation = 1.0f;
    private float m_negativeSaturation = 1.0f;
    private ColorDistributionTypes m_colorDistribution = ColorDistributionTypes.Linear;

    public HSBTreeMapColorProvider(KTreeMap treeMap, Color color) {
        this(treeMap, ColorDistributionTypes.Linear, color, color);
    }

    public HSBTreeMapColorProvider(KTreeMap treeMap, Color positiveColor, Color negativeColor) {
        this(treeMap, ColorDistributionTypes.Linear, positiveColor, negativeColor);
    }

    public HSBTreeMapColorProvider(KTreeMap treeMap, ColorDistributionTypes colorDistribution, Color color) {
        this(treeMap, colorDistribution, color, color);
    }

    public HSBTreeMapColorProvider(KTreeMap treeMap, ColorDistributionTypes colorDistribution, Color positiveColor, Color negativeColor) {
        this.m_jTreeMap = treeMap;
        this.m_colorDistribution = colorDistribution;
        this.adjustColor(positiveColor, negativeColor);
    }

    public HSBTreeMapColorProvider(KTreeMap treeMap, ColorDistributionTypes colorDistribution, float hue, float saturation) {
        this(treeMap, colorDistribution, hue, saturation, hue, saturation);
    }

    public HSBTreeMapColorProvider(KTreeMap treeMap, ColorDistributionTypes colorDistribution, float positiveHue, float positiveSaturation, float negativeHue, float negativeSaturation) {
        this.m_jTreeMap = treeMap;
        this.m_colorDistribution = colorDistribution;
        this.adjustColor(positiveHue, positiveSaturation, negativeHue, negativeSaturation);
    }

    public HSBTreeMapColorProvider(KTreeMap treeMap, float hue, float saturation) {
        this(treeMap, ColorDistributionTypes.Linear, hue, saturation, hue, saturation);
    }

    public HSBTreeMapColorProvider(KTreeMap treeMap, float positiveHue, float positiveSaturation, float negativeHue, float negativeSaturation) {
        this(treeMap, ColorDistributionTypes.Linear, positiveHue, positiveSaturation, negativeHue, negativeSaturation);
    }

    public void adjustColor(Color color) {
        this.adjustColor(color, color);
    }

    public void adjustColor(Color positiveColor, Color negativeColor) {
        float[] hsbvals = new RGB(positiveColor.getRed(), positiveColor.getGreen(), positiveColor.getBlue()).getHSB();
        this.m_positiveHue = hsbvals[0];
        this.m_positiveSaturation = 1.0f;
        hsbvals = new RGB(negativeColor.getRed(), negativeColor.getGreen(), negativeColor.getBlue()).getHSB();
        this.m_negativeHue = hsbvals[0];
        this.m_negativeSaturation = 1.0f;
    }

    public void adjustColor(float hue, float saturation) {
        this.adjustColor(hue, saturation, hue, saturation);
    }

    public void adjustColor(float positiveHue, float positiveSaturation, float negativeHue, float negativeSaturation) {
        this.m_positiveHue = positiveHue;
        this.m_positiveSaturation = positiveSaturation;
        this.m_negativeHue = negativeHue;
        this.m_negativeSaturation = negativeSaturation;
    }

    public Color getBackground(Object value) {
        if (this.m_maxValue == Double.MIN_VALUE || this.m_minValue == Double.MAX_VALUE) {
            this.setValues(this.m_jTreeMap.getRoot());
        }
        ITreeMapProvider provider = this.m_jTreeMap.getTreeMapProvider();
        double val = provider.getDoubleValue(value);
        return this.getBackground(val);
    }

    public Color getForeground(Object value) {
        return Display.getDefault().getSystemColor(1);
    }

    @Override
    public Composite getLegend(Composite parent, int style) {
        return new Legend(parent, style);
    }

    void setValues(TreeMapNode root) {
        if (root.isLeaf()) {
            Object value = root.getValue();
            ITreeMapProvider provider = this.m_jTreeMap.getTreeMapProvider();
            double rootValue = provider.getDoubleValue(value);
            if (rootValue >= this.m_maxValue) {
                this.m_maxValue = rootValue;
            }
            if (rootValue <= this.m_minValue) {
                this.m_minValue = rootValue;
            }
        } else {
            for (TreeMapNode node : root.getChildren()) {
                this.setValues(node);
            }
        }
    }

    private double adjustValue(double value) {
        switch (this.m_colorDistribution) {
            case Log: {
                return Math.log1p(value);
            }
            case Exp: {
                return Math.exp(value);
            }
            case SquareRoot: {
                return Math.sqrt(value);
            }
            case CubicRoot: {
                return Math.cbrt(value);
            }
        }
        return value;
    }

    private Color getBackground(double val) {
        double maxValue = this.m_maxValue;
        double minValue = this.m_minValue;
        if (val >= 0.0) {
            double range = maxValue - Math.max(0.0, minValue);
            range = this.adjustValue(range);
            RGB cc = new RGB(this.m_positiveHue, this.m_positiveSaturation, (float)(this.adjustValue(val -= Math.max(0.0, minValue)) / range));
            return ResourceManager.getColor(cc.red, cc.green, cc.blue);
        }
        double range = Math.abs(minValue - Math.min(0.0, maxValue));
        val += Math.min(0.0, maxValue);
        val = Math.abs(val);
        range = this.adjustValue(range);
        RGB cc = new RGB(this.m_negativeHue, this.m_negativeSaturation, (float)(this.adjustValue(val) / range));
        return ResourceManager.getColor(cc.red, cc.green, cc.blue);
    }

    private class Legend
    extends Canvas {
        public Legend(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Legend.this.paintControl(e);
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int height = 20;
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(wHint, height);
        }

        protected void paintControl(PaintEvent e) {
            GC gc = e.gc;
            int width = this.getBounds().width;
            double step = (HSBTreeMapColorProvider.this.m_maxValue - HSBTreeMapColorProvider.this.m_minValue) / (double)width;
            double value = HSBTreeMapColorProvider.this.m_minValue;
            for (int i = 0; i < width; ++i) {
                gc.setBackground(HSBTreeMapColorProvider.this.getBackground(value));
                gc.fillRectangle(i, 0, 1, this.getBounds().height);
                value += step;
            }
        }
    }

    public static enum ColorDistributionTypes {
        Linear,
        Log,
        Exp,
        SquareRoot,
        CubicRoot;

    }
}

