/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.ktreemap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TreeMapNode {
    private static final long serialVersionUID = 742372833853976103L;
    private static int border = 3;
    private double weight = 0.0;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private Object value;
    private ArrayList<TreeMapNode> children = new ArrayList();
    private TreeMapNode parent;

    public TreeMapNode(Object value) {
        this.value = value;
    }

    public TreeMapNode(Object value, double weight) {
        this.value = value;
        this.weight = Math.abs(weight);
    }

    public static int getBorder() {
        return border;
    }

    public static void setBorder(int border) {
        TreeMapNode.border = border;
    }

    public void add(TreeMapNode newChild) {
        this.children.add(newChild);
        newChild.setParent(this);
        this.setWeight(this.weight + newChild.getWeight());
    }

    public TreeMapNode getActiveLeaf(int x, int y) {
        if (this.isLeaf()) {
            if (x >= this.getX() && x <= this.getX() + this.getWidth() && y >= this.getY() && y <= this.getY() + this.getHeight()) {
                return this;
            }
        } else {
            for (TreeMapNode node : this.children) {
                if (x < node.getX() || x > node.getX() + node.getWidth() || y < node.getY() || y > node.getY() + node.getHeight()) continue;
                return node.getActiveLeaf(x, y);
            }
        }
        return null;
    }

    public TreeMapNode getActiveLeaf(Point position) {
        if (position != null) {
            return this.getActiveLeaf(position.x, position.y);
        }
        return null;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public TreeMapNode getChild(int x, int y) {
        if (!this.isLeaf()) {
            for (TreeMapNode node : this.children) {
                if (x < node.getX() || x > node.getX() + node.getWidth() || y < node.getY() || y > node.getY() + node.getHeight()) continue;
                return node;
            }
        }
        return null;
    }

    public TreeMapNode getChild(Point position) {
        if (position != null) {
            return this.getChild(position.x, position.y);
        }
        return null;
    }

    public List<TreeMapNode> getChildren() {
        return this.children;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Object getValue() {
        return this.value;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getX() {
        return this.bounds.x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setHeight(int height) {
        this.bounds.height = height;
    }

    public void setPosition(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    public void setSize(int width, int height) {
        this.bounds.width = width;
        this.bounds.height = height;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setWeight(double weight) {
        double newWeight = Math.abs(weight);
        if (this.parent != null) {
            this.parent.setWeight(this.parent.weight - this.weight + newWeight);
        }
        this.weight = newWeight;
    }

    public void setWidth(int width) {
        this.bounds.width = width;
    }

    public void setX(int x) {
        this.bounds.x = x;
    }

    public void setY(int y) {
        this.bounds.y = y;
    }

    public TreeMapNode getParent() {
        return this.parent;
    }

    protected void setParent(TreeMapNode parent) {
        this.parent = parent;
    }
}

