/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.Modifiers;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class DefaultTestDetector
implements TestDetector {
    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        if (sourceContext.areAnnotationsSupported() && typeContext.getModifiers() != null && typeContext.getModifiers().containsAnnotation("org.testng.annotations.Test", "Test", "org.spockframework.runtime.model.SpecMetadata", "SpecMetadata") || typeContext.getDocTags() != null && typeContext.getDocTags().containsKey("testng.test")) {
            return true;
        }
        return !(!this.strContains(typeContext.getTypeName(), "test") && !this.strEquals(typeContext.getSuperTypeName(), "TestCase") && !this.strEquals(typeContext.getSuperTypeName(), "junit.framework.TestCase") || !sourceContext.areAnnotationsSupported() && !this.strContains(typeContext.getSuperTypeName(), "test"));
    }

    private boolean strContains(String target, String str) {
        return target != null && target.toLowerCase().contains(str);
    }

    private boolean strEquals(String target, String str) {
        return target != null && target.equals(str);
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        MethodSignature signature = methodContext.getSignature();
        if (methodContext != null && !Modifier.isAbstract(signature.getModifiersMask()) && !Modifier.isPrivate(signature.getModifiersMask()) && signature.getReturnType() != null) {
            if (sourceContext.areAnnotationsSupported() && this.hasTestAnnotations(signature.getModifiers()) || this.hasTestTags(signature.getTags())) {
                return true;
            }
            if (Modifier.isPublic(signature.getModifiersMask()) && signature.getName().startsWith("test") && !signature.hasParams()) {
                return true;
            }
        }
        return false;
    }

    protected boolean hasTestAnnotations(Modifiers modifiers) {
        return modifiers.containsAnnotation("org.junit.Test", "org.junit.jupiter.api.Test", "org.testng.annotations.Test", "Test", "org.spockframework.runtime.model.FeatureMetadata", "FeatureMetadata", "ParameterizedTest", "org.junit.jupiter.params.ParameterizedTest") && !modifiers.containsAnnotation("org.junit.Ignore", "org.junit.jupiter.api.Disabled", "Ignore", "Disabled");
    }

    protected boolean hasTestTags(Map<String, List<String>> tags) {
        return tags.containsKey("test") || tags.containsKey("testng.test");
    }
}

