/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.CloverNames;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.instr.java.JavaMethodContext;
import com.atlassian.clover.instr.tests.ExpectedExceptionMiner;
import com.atlassian.clover.instr.tests.naming.DefaultTestNameExtractor;
import com.atlassian.clover.instr.tests.naming.JUnitParameterizedTestExtractor;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import com.atlassian.clover.util.CloverUtils;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class MethodRegistrationNode
extends Emitter {
    private static final Map DEFAULT_RETURN_VALUES;
    private MethodSignature signature;
    private FullMethodInfo method;

    static {
        HashMap values = Maps.newHashMap();
        values.put("boolean", "false");
        values.put("byte", "0");
        values.put("short", "0");
        values.put("char", "0");
        values.put("int", "0");
        values.put("long", "0l");
        values.put("float", "0f");
        values.put("double", "0d");
        DEFAULT_RETURN_VALUES = Collections.unmodifiableMap(values);
    }

    public MethodRegistrationNode(ContextSet context, MethodSignature signature, int line, int col) {
        super(context, line, col);
        this.signature = signature;
    }

    @Override
    protected boolean acceptsContextType(NamedContext context) {
        return context instanceof MethodRegexpContext;
    }

    @Override
    public void init(InstrumentationState state) {
        boolean addTestRewriteInstr;
        JavaInstrumentationConfig cfg = state.getCfg();
        boolean isTestMethod = state.isDetectTests() && state.getTestDetector().isMethodMatch(state, JavaMethodContext.createFor(this.signature));
        String javaLangPrefix = cfg.getJavaLangPrefix();
        boolean bl = addTestRewriteInstr = state.isInstrEnabled() && cfg.isRecordTestResults() && isTestMethod;
        if (isTestMethod && !state.isParameterizedJUnit5TestClass()) {
            state.setParameterizedJUnit5TestClass(JUnitParameterizedTestExtractor.isJUnit5ParameterizedTest(this.signature));
        }
        this.method = (FullMethodInfo)state.getSession().enterMethod(this.getElementContext(), new FixedSourceRegion(this.getLine(), this.getColumn()), this.signature, isTestMethod, null, false, 1, LanguageConstruct.Builtin.METHOD);
        this.method.setStaticTestName(DefaultTestNameExtractor.INSTANCE.getTestNameForMethod(this.method));
        if (addTestRewriteInstr) {
            boolean nonVoidReturn;
            List expectedExceptions = state.isDetectTests() ? Lists.newArrayList(ExpectedExceptionMiner.extractExpectedExceptionsFor(this.signature, true)) : Collections.emptyList();
            boolean expectsExceptions = expectedExceptions.size() > 0;
            String syntheticTestName = CloverUtils.createSyntheticTestName(this.method);
            StringBuilder instr = new StringBuilder();
            instr.append("{");
            String typeInstr = "getClass().getName()";
            if (Modifier.isStatic(this.getSignature().getModifiersMask())) {
                typeInstr = String.valueOf(this.getMethod().getContainingClass().getName()) + ".class.getName()";
            }
            instr.append(Bindings.$CoverageRecorder$globalSliceStart(state.getRecorderPrefix(), typeInstr, Integer.toString(this.method.getDataIndex()))).append(";");
            instr.append("int ").append(CloverNames.namespace("p")).append("=").append(0).append(";");
            instr.append(javaLangPrefix).append("Throwable ").append(CloverNames.namespace("t")).append("=null;");
            instr.append("try{");
            boolean bl2 = nonVoidReturn = this.signature.getReturnType() != null && !"void".equals(this.signature.getReturnType());
            if (nonVoidReturn) {
                instr.append(this.signature.getReturnType()).append(" ").append(CloverNames.namespace("r")).append("=");
            }
            instr.append(syntheticTestName);
            instr.append("(").append(this.signature.listParamIdents()).append(");");
            instr.append(CloverNames.namespace("p")).append("=");
            if (expectsExceptions) {
                instr.append(0).append(";").append(CloverNames.namespace("t")).append("=new ").append(javaLangPrefix).append("RuntimeException(");
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Expected one of the following exceptions to be thrown from test method ").append(this.method.getSimpleName()).append(": ").append("[");
                int i = 0;
                while (i < expectedExceptions.size()) {
                    String expectedException = (String)expectedExceptions.get(i);
                    msgBuffer.append(expectedException).append(i < expectedExceptions.size() - 1 ? ", " : "");
                    ++i;
                }
                msgBuffer.append("]");
                instr.append("new String(new char[] {");
                i = 0;
                while (i < msgBuffer.length()) {
                    instr.append((int)msgBuffer.charAt(i)).append(",");
                    ++i;
                }
                instr.append("}));");
            } else {
                instr.append(1).append(";");
            }
            if (nonVoidReturn) {
                instr.append("return ").append(CloverNames.namespace("r")).append(";");
            }
            instr.append("}catch(").append(javaLangPrefix).append("Throwable ").append(CloverNames.namespace("t2")).append(")").append("{");
            if (expectsExceptions) {
                instr.append("if(");
                int i = 0;
                while (i < expectedExceptions.size()) {
                    String expectedException = (String)expectedExceptions.get(i);
                    instr.append(CloverNames.namespace("t2")).append(" instanceof ").append(expectedException);
                    if (i < expectedExceptions.size() - 1) {
                        instr.append("||");
                    }
                    ++i;
                }
                instr.append("){").append(CloverNames.namespace("p")).append("=").append(1).append(";").append(CloverNames.namespace("t")).append("=null;}else{").append(CloverNames.namespace("p")).append("=").append(0).append(";").append(CloverNames.namespace("t")).append("=").append(CloverNames.namespace("t2")).append(";}");
            }
            instr.append("if(").append(CloverNames.namespace("p")).append("==").append(0).append("&&").append(CloverNames.namespace("t")).append("==null){").append(CloverNames.namespace("t")).append("=").append(CloverNames.namespace("t2")).append(";}");
            instr.append(Bindings.$CoverageRecorder$rethrow(state.getRecorderPrefix(), CloverNames.namespace("t2"))).append(";");
            if (nonVoidReturn) {
                instr.append("return ").append(MethodRegistrationNode.defaultNullValueForType(this.signature.getReturnType())).append(";");
            }
            instr.append("}");
            instr.append("finally{");
            instr.append(Bindings.$CoverageRecorder$globalSliceEnd(state.getRecorderPrefix(), typeInstr, "\"" + this.method.getQualifiedName() + "\"", "__CLR4_5_0_TEST_NAME_SNIFFER.getTestName()", Integer.toString(this.method.getDataIndex()), CloverNames.namespace("p"), CloverNames.namespace("t")));
            instr.append(";");
            instr.append("}}");
            instr.append(this.signature.getRenamedNormalisedSignature(syntheticTestName));
            this.setInstr(instr.toString());
        }
    }

    private static String defaultNullValueForType(String returnType) {
        return String.valueOf(DEFAULT_RETURN_VALUES.get(returnType));
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    @Override
    public void addContext(NamedContext ctx) {
        super.addContext(ctx);
        if (this.method != null) {
            this.method.addContext(ctx);
        }
    }
}

