/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.spi.lang.LanguageConstruct;

public class ArmInstrEmitter
extends Emitter {
    private int endLine;
    private int endCol;
    private int complexity;
    private FullStatementInfo stmtInfo;

    public ArmInstrEmitter(ContextSet context, int line, int column, int endLine, int endCol) {
        this(context, line, column, endLine, endCol, 0);
    }

    public ArmInstrEmitter(ContextSet context, int line, int column, int endLine, int endCol, int complexity) {
        super(context, line, column);
        this.endLine = endLine;
        this.endCol = endCol;
        this.complexity = complexity;
    }

    @Override
    public void init(InstrumentationState state) {
        this.stmtInfo = state.getSession().addStatement(this.getElementContext(), new FixedSourceRegion(this.getLine(), this.getColumn(), this.endLine, this.endCol), this.complexity, LanguageConstruct.Builtin.STATEMENT);
        if (state.isInstrEnabled()) {
            state.setDirty();
            int autoCloseableClassIndex = state.getAutoCloseableClassCount() - 1;
            String autoCloseableTypeName = "__CLR4_5_0$AC" + autoCloseableClassIndex;
            int autoCloseableInstanceIndex = state.incAutoCloseableInstanceCount() - 1;
            String autoCloseableInstanceName = "__CLR$ACI" + autoCloseableInstanceIndex;
            this.setInstr(String.valueOf(autoCloseableTypeName) + " " + autoCloseableInstanceName + "=new " + autoCloseableTypeName + "(){{" + Bindings.$CoverageRecorder$inc(state.getRecorderPrefix(), Integer.toString(this.stmtInfo.getDataIndex())) + ";}};");
        }
    }

    @Override
    public void addContext(NamedContext ctx) {
        super.addContext(ctx);
        if (this.stmtInfo != null) {
            this.stmtInfo.addContext(ctx);
        }
    }
}

