/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openclover.util.Sets;

public class TestCaseInfoLookup {
    private ConcurrentHashMap<Integer, TestCaseInfo> byId = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TestCaseInfo> byQualifiedName = new ConcurrentHashMap();

    public void add(TestCaseInfo tci) {
        this.byId.putIfAbsent(tci.getId(), tci);
        this.byQualifiedName.putIfAbsent(tci.getQualifiedName(), tci);
    }

    public TestCaseInfo getBy(Integer id) {
        return this.byId.get(id);
    }

    public TestCaseInfo getBy(String qualifiedName) {
        return this.byQualifiedName.get(qualifiedName);
    }

    public Set<TestCaseInfo> getTestCaseInfos() {
        return Sets.newHashSet(this.byId.values());
    }
}

