/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.testopt.settings;

import com.atlassian.clover.api.optimization.OptimizationOptions;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.testopt.TestOptimizationPluginMessages;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class TestOptimizationPreferencesControl
extends Composite {
    private final BooleanFieldEditor showNoTestsEditor;
    private BooleanFieldEditor discardSnapshotEditor;
    private IntegerFieldEditor discardSnapshotAgeEditor;
    private final BooleanFieldEditor minimizeTestsEditor;
    private final RadioGroupFieldEditor testReorderingEditor;
    private final Collection<FieldEditor> allEditors = Lists.newArrayList();
    private final Map<FieldEditor, Composite> parents = Maps.newHashMap();
    private static final String[][] TEST_REORDERING_OPTIONS = new String[][]{{TestOptimizationPluginMessages.getString("launch.optimized.prefs.testsreordering.none"), OptimizationOptions.TestSortOrder.NONE.name()}, {TestOptimizationPluginMessages.getString("launch.optimized.prefs.testsreordering.failfast"), OptimizationOptions.TestSortOrder.FAILFAST.name()}, {TestOptimizationPluginMessages.getString("launch.optimized.prefs.testsreordering.random"), OptimizationOptions.TestSortOrder.RANDOM.name()}};
    private Composite discardAgeParent;
    private Label compilesLabel;
    private final IPropertyChangeListener discardSnapshotAgeEnabler = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            TestOptimizationPreferencesControl.this.discardSnapshotAgeEditor.setEnabled(TestOptimizationPreferencesControl.this.isEnabled() && TestOptimizationPreferencesControl.this.discardSnapshotEditor.getBooleanValue(), TestOptimizationPreferencesControl.this.discardAgeParent);
        }
    };

    public TestOptimizationPreferencesControl(Composite parent, DialogPage page, IPreferenceStore preferenceStore) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        Composite snteComposite = new Composite((Composite)this, 0);
        this.showNoTestsEditor = this.addEditor(new BooleanFieldEditor("org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG", TestOptimizationPluginMessages.getString("launch.optimized.prefs.shownotestsfound"), snteComposite), snteComposite);
        this.createDiscardPanel();
        Composite mteComposite = new Composite((Composite)this, 0);
        this.minimizeTestsEditor = this.addEditor(new BooleanFieldEditor("org.openclover.eclipse.testopt.MINIMIZE_TESTS", TestOptimizationPluginMessages.getString("launch.optimized.prefs.testsminimize"), mteComposite), mteComposite);
        Composite testReorderingParent = new Composite((Composite)this, 0);
        GridData layoutData1 = new GridData(768);
        testReorderingParent.setLayoutData((Object)layoutData1);
        this.testReorderingEditor = this.addEditor(new RadioGroupFieldEditor("org.openclover.eclipse.testopt.TEST_REORDERING", TestOptimizationPluginMessages.getString("launch.optimized.prefs.testsreordering"), 1, TEST_REORDERING_OPTIONS, testReorderingParent, true), testReorderingParent);
        for (FieldEditor editor : this.allEditors) {
            editor.setPage(page);
            editor.setPreferenceStore(preferenceStore);
        }
        this.load();
    }

    private void createDiscardPanel() {
        Composite composite = new Composite((Composite)this, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)new GLH(3, false).marginWidth(0).marginHeight(0).getGridLayout());
        Composite dseComposite = new Composite(composite, 0);
        this.discardSnapshotEditor = this.addEditor(new BooleanFieldEditor("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS", TestOptimizationPluginMessages.getString("launch.optimized.prefs.dicardstale"), dseComposite), dseComposite);
        this.discardAgeParent = new Composite(composite, 0);
        this.discardAgeParent.setLayoutData((Object)new GridData(4, 2, true, false));
        this.discardSnapshotAgeEditor = this.addEditor(new IntegerFieldEditor("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE", "", this.discardAgeParent, 6), this.discardAgeParent);
        this.discardSnapshotAgeEditor.setValidRange(2, 10000);
        this.compilesLabel = new Label(composite, 0);
        this.compilesLabel.setText("compiles");
        this.compilesLabel.setLayoutData((Object)new GridData(4, 2, true, false));
        this.discardSnapshotEditor.setPropertyChangeListener(this.discardSnapshotAgeEnabler);
    }

    protected void loadDefaults() {
        for (FieldEditor editor : this.allEditors) {
            editor.loadDefault();
        }
        this.discardSnapshotAgeEnabler.propertyChange(null);
    }

    public void load() {
        for (FieldEditor editor : this.allEditors) {
            editor.load();
        }
        this.discardSnapshotAgeEnabler.propertyChange(null);
    }

    public void store() {
        for (FieldEditor editor : this.allEditors) {
            if (!editor.isValid()) continue;
            editor.store();
        }
    }

    public void setPropertyChangeListener(final IPropertyChangeListener listener) {
        for (FieldEditor editor : this.allEditors) {
            if (editor == this.discardSnapshotEditor) {
                this.discardSnapshotEditor.setPropertyChangeListener(listener == null ? this.discardSnapshotAgeEnabler : new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        TestOptimizationPreferencesControl.this.discardSnapshotAgeEnabler.propertyChange(event);
                        listener.propertyChange(event);
                    }
                });
                continue;
            }
            editor.setPropertyChangeListener(listener);
        }
    }

    public boolean isValid() {
        for (FieldEditor editor : this.allEditors) {
            if (editor.isValid()) continue;
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (FieldEditor editor : this.allEditors) {
            editor.setEnabled(enabled, this.getParent(editor));
        }
        this.compilesLabel.setEnabled(enabled);
        this.testReorderingEditor.getRadioBoxControl(this.getParent((FieldEditor)this.testReorderingEditor)).setEnabled(enabled);
        if (enabled) {
            this.discardSnapshotAgeEnabler.propertyChange(null);
        }
    }

    private <T extends FieldEditor> T addEditor(T editor, Composite parent) {
        this.allEditors.add(editor);
        this.parents.put(editor, parent);
        return editor;
    }

    private Composite getParent(FieldEditor editor) {
        return this.parents.get(editor);
    }
}

