/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.testopt.editors.ruler.tree;

import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.openclover.eclipse.testopt.editors.ruler.CoverageAnnotationRulerHover;
import org.openclover.util.Maps;

public class CoverageAnnotationContentProvider
implements ITreeContentProvider {
    private final Map<String, Map<String, TestCaseInfo>> data = Maps.newHashMap();

    public Object[] getChildren(Object parentElement) {
        Map<String, TestCaseInfo> map = this.data.get(parentElement);
        return map == null ? null : map.values().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof TestCaseInfo) {
            return ((TestCaseInfo)element).getRuntimeTypeName();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.data.containsKey(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.data.keySet().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object inputElement) {
        this.data.clear();
        if (inputElement instanceof CoverageAnnotationRulerHover.CoverageAnnotationInput) {
            Collection<TestCaseInfo> testCases = ((CoverageAnnotationRulerHover.CoverageAnnotationInput)inputElement).testCases;
            for (TestCaseInfo tci : testCases) {
                String testName;
                TestCaseInfo prev;
                String testClass = tci.getRuntimeTypeName();
                HashMap tests = this.data.get(testClass);
                if (tests == null) {
                    tests = Maps.newHashMap();
                    this.data.put(testClass, tests);
                }
                if ((prev = (TestCaseInfo)tests.get(testName = tci.getSourceMethodName())) != null && prev.getEndTime() >= tci.getEndTime()) continue;
                tests.put(testName, tci);
            }
        }
    }
}

