/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.testopt.editors.ruler;

import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.editors.text.EditorsUI;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotation;
import org.openclover.eclipse.core.ui.editors.java.ILineCoverageModel;
import org.openclover.eclipse.testopt.editors.ruler.CoverageAnnotationRulerHover;
import org.openclover.eclipse.testopt.editors.ruler.tree.CoverageAnnotationContentProvider;
import org.openclover.eclipse.testopt.editors.ruler.tree.TestNameLabelProvider;

public class CoverageAnnotationRulerInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    private TreeViewer treeViewer;
    private CoverageAnnotationRulerHover.CoverageAnnotationInput lastInput;

    public CoverageAnnotationRulerInformationControl(Shell parentShell) {
        super(parentShell, 16400, false, true, true, true, false, "", "");
        this.create();
    }

    public void setInput(Object input) {
        this.lastInput = input instanceof CoverageAnnotationRulerHover.CoverageAnnotationInput ? (CoverageAnnotationRulerHover.CoverageAnnotationInput)input : null;
        this.treeViewer.setInput(input);
        if (this.lastInput != null) {
            String message = this.getText(this.lastInput.annotation) + "\nCovered by " + this.lastInput.testCases.size() + " test runs";
            this.setTitleText(message);
        } else {
            this.setTitleText("");
        }
        this.setInfoText(EditorsUI.getTooltipAffordanceString());
    }

    private String getText(ILineCoverageModel.Entry annotation) {
        CoverageAnnotation.Kind kind = CoverageAnnotation.Kind.kindFor((boolean)false, (ElementInfo)annotation.getElementInfo(), (Set)annotation.getTestCaseInfos());
        return CoverageAnnotation.textForCoverage((ElementInfo)annotation.getElementInfo(), (CoverageAnnotation.Kind)kind, (Set)annotation.getTestCaseInfos());
    }

    public boolean hasContents() {
        return this.lastInput != null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout());
        this.treeViewer = new TreeViewer(parent, 516);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, 200).applyTo(this.treeViewer.getControl());
        this.treeViewer.setContentProvider((IContentProvider)new CoverageAnnotationContentProvider());
        final TreeViewerColumn nameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        nameColumn.getColumn().setText("Test Cases");
        nameColumn.getColumn().setResizable(true);
        nameColumn.setLabelProvider((CellLabelProvider)new TestNameLabelProvider());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (o instanceof TestCaseInfo) {
                    TestCaseInfo tci = (TestCaseInfo)o;
                    String pattern = tci.getSourceMethodName();
                    SearchPattern searchPattern = SearchPattern.createPattern((String)pattern, (int)1, (int)0, (int)8);
                    IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
                    SearchRequestor requestor = new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            Object element = match.getElement();
                            if (element instanceof IJavaElement) {
                                JavaUI.openInEditor((IJavaElement)((IJavaElement)element));
                            }
                        }
                    };
                    SearchEngine searchEngine = new SearchEngine();
                    try {
                        searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else {
                    TreePath[] paths = ((ITreeSelection)event.getViewer().getSelection()).getPaths();
                    if (paths.length > 0) {
                        if (CoverageAnnotationRulerInformationControl.this.treeViewer.getExpandedState((Object)paths[0])) {
                            CoverageAnnotationRulerInformationControl.this.treeViewer.collapseToLevel((Object)paths[0], -1);
                        } else {
                            CoverageAnnotationRulerInformationControl.this.treeViewer.expandToLevel((Object)paths[0], 1);
                        }
                    }
                }
            }
        });
        this.treeViewer.getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Tree tree = CoverageAnnotationRulerInformationControl.this.treeViewer.getTree();
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && item.getData() instanceof TestCaseInfo) {
                    if (tree.getCursor() == null) {
                        tree.setCursor(tree.getDisplay().getSystemCursor(21));
                    }
                } else {
                    tree.setCursor(null);
                }
            }
        });
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.getControl().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = CoverageAnnotationRulerInformationControl.this.treeViewer.getTree().getClientArea();
                nameColumn.getColumn().setWidth(clientArea.width);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return mainComposite;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().computeSize(-1, -1);
    }

    public void dispose() {
        this.close();
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.setInfoText("Double-click the test name to open test source");
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setLocation(Point location) {
        this.getShell().setLocation(location);
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }
}

