/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.testopt;

import com.atlassian.clover.optimization.OptimizationSession;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.openclover.eclipse.testopt.OptimizationSessionListener;
import org.openclover.eclipse.testopt.OptimizedTestRunListener;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class TestOptimizationPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.openclover.eclipse.testopt";
    public static final String USE_DEFAULT_SETTINGS = "org.openclover.eclipse.testopt.USE_DEFAULT_SETTINGS";
    public static final String SHOW_NO_TESTS_FOUND_DIALOG = "org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG";
    public static final String DISCARD_STALE_SNAPSHOTS = "org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS";
    public static final String DISCARD_STALE_SNAPSHOTS_AGE = "org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE";
    public static final String MINIMIZE_TESTS = "org.openclover.eclipse.testopt.MINIMIZE_TESTS";
    public static final String TEST_REORDERING = "org.openclover.eclipse.testopt.TEST_REORDERING";
    public static final String LAST_LAUNCH_CONFIGURATION = "LAST_LAUNCH_CONFIGURATION";
    public static final String TEST_OPTIMIZATION_ICON = "icons/run_optimized.png";
    private final OptimizedTestRunListener optimizedTestRunListener = new OptimizedTestRunListener();
    private ILaunchConfiguration lastLaunchConfiguration;
    private static TestOptimizationPlugin instance;
    private final Collection<OptimizationSessionListener> optimizationSessionListeners = new CopyOnWriteArraySet<OptimizationSessionListener>();

    public static TestOptimizationPlugin getDefault() {
        return instance;
    }

    public TestOptimizationPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        JUnitCore.addTestRunListener((TestRunListener)this.optimizedTestRunListener);
        this.loadLastLaunchConfiguration();
    }

    public void stop(BundleContext context) throws Exception {
        JUnitCore.removeTestRunListener((TestRunListener)this.optimizedTestRunListener);
        super.stop(context);
    }

    public static void log(int eclipseLevel, String msg, Throwable t) {
        instance.getLog().log((IStatus)new Status(eclipseLevel, ID, 0, msg, t));
    }

    public static void log(int eclipseLevel, String msg) {
        TestOptimizationPlugin.log(eclipseLevel, msg, null);
    }

    public static void logVerbose(String message) {
        TestOptimizationPlugin.logVerbose(message, null);
    }

    public static void logVerbose(String message, Throwable t) {
        TestOptimizationPlugin.log(0, message, t);
    }

    public static void logDebug(String message) {
        TestOptimizationPlugin.logDebug(message, null);
    }

    public static void logDebug(String message, Throwable t) {
        TestOptimizationPlugin.log(0, message, t);
    }

    public static void logInfo(String message) {
        TestOptimizationPlugin.logInfo(message, null);
    }

    public static void logInfo(String message, Throwable t) {
        TestOptimizationPlugin.log(1, message, t);
    }

    public static void logWarning(String message) {
        TestOptimizationPlugin.logWarning(message, null);
    }

    public static void logWarning(String message, Throwable t) {
        TestOptimizationPlugin.log(2, message, t);
    }

    public static void logError(String message) {
        TestOptimizationPlugin.logError(message, null);
    }

    public static void logError(String message, Throwable t) {
        TestOptimizationPlugin.log(4, message, t);
    }

    public Image getTestOptimizationIcon() {
        ImageRegistry reg = this.getImageRegistry();
        if (reg.getDescriptor(TEST_OPTIMIZATION_ICON) == null) {
            reg.put(TEST_OPTIMIZATION_ICON, ImageDescriptor.createFromURL((URL)instance.getBundle().getEntry(TEST_OPTIMIZATION_ICON)));
        }
        return reg.get(TEST_OPTIMIZATION_ICON);
    }

    public void addOptimizationSessionListener(OptimizationSessionListener listener) {
        this.optimizationSessionListeners.add(listener);
    }

    public void removeOptimizationSessionListener(OptimizationSessionListener listener) {
        this.optimizationSessionListeners.remove(listener);
    }

    public void notifyOptimizationSessionListener(OptimizationSession session) {
        for (OptimizationSessionListener listener : this.optimizationSessionListeners) {
            listener.sessionFinished(session);
        }
    }

    public ILaunchConfiguration getLastLaunchConfiguration() {
        return this.lastLaunchConfiguration;
    }

    public void setLastLaunchConfiguration(ILaunchConfiguration lastLaunchConfiguration) {
        if (this.lastLaunchConfiguration != lastLaunchConfiguration) {
            this.lastLaunchConfiguration = lastLaunchConfiguration;
            try {
                this.saveToPreferences(LAST_LAUNCH_CONFIGURATION, lastLaunchConfiguration != null ? lastLaunchConfiguration.getMemento() : null);
            }
            catch (CoreException | BackingStoreException e) {
                TestOptimizationPlugin.logError("Cannot store last launch configuration", e);
            }
        }
    }

    private void saveToPreferences(String key, String value) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.openclover.eclipse.core");
        prefs.put(key, value);
        prefs.flush();
    }

    private void loadLastLaunchConfiguration() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.openclover.eclipse.core");
        String memento = prefs.get(LAST_LAUNCH_CONFIGURATION, "");
        try {
            this.lastLaunchConfiguration = memento == null || memento.length() == 0 ? null : DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
        }
        catch (CoreException e) {
            this.lastLaunchConfiguration = null;
            TestOptimizationPlugin.logWarning("Cannot read last launch configuration", e);
        }
    }
}

