/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CloverAntPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.openclover.eclipse.ant";
    private static final String CLOVER_LICENSE_KEY = "clover_license";
    private static final String CORE_ID = "org.openclover.eclipse.core";
    private static CloverAntPlugin INSTANCE;

    public static CloverAntPlugin getInstance() {
        return INSTANCE;
    }

    public CloverAntPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.updateLicenseFile();
    }

    public void updateLicenseFile() throws IOException {
        String licenseText = ConfigurationScope.INSTANCE.getNode(CORE_ID).get(CLOVER_LICENSE_KEY, "");
        File licenseFile = this.getLicenseFile();
        if (!licenseFile.exists()) {
            licenseFile.createNewFile();
        }
        FileWriter writer = new FileWriter(licenseFile);
        writer.write(licenseText);
        writer.flush();
        writer.close();
    }

    public File getLicenseFile() throws IOException {
        URL locationUrl = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("/"), null);
        URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
        return new File(fileUrl.getFile(), "clover.license");
    }
}

