/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.testopt.editors.ruler;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.eclipse.core.ui.editors.java.CoverageAnnotation;
import com.atlassian.clover.eclipse.core.ui.editors.java.CoverageAnnotationModel;
import com.atlassian.clover.eclipse.core.ui.editors.java.ILineCoverageModel;
import com.atlassian.clover.eclipse.testopt.editors.ruler.CoverageAnnotationRulerHover;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;

public class CoverageAnnotationRulerColumn
extends AbstractRulerColumn
implements IContributedRulerColumn {
    private RulerColumnDescriptor fDescriptor;
    private ITextEditor fEditor;
    private CoverageAnnotationModel coverageAnnotationModel;
    private final Color colorCovered;
    private final Color colorFailCovered;
    private final Color colorNotCovered;
    private final Color colorCoveredByPassedTest;
    private final Color colorCoveredByFailedTest;
    private final IAnnotationModelListener annotationListener = new IAnnotationModelListener(){

        public void modelChanged(IAnnotationModel model) {
            if (CoverageAnnotationRulerColumn.this.coverageAnnotationModel == null) {
                CoverageAnnotationRulerColumn.this.coverageAnnotationModel = CoverageAnnotationModel.getModel((ITextEditor)CoverageAnnotationRulerColumn.this.fEditor);
            }
        }
    };

    public CoverageAnnotationRulerColumn() {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        RGB rgbCovered = lookup.getAnnotationPreference(CoverageAnnotation.Kind.COVERED.getId()).getColorPreferenceValue();
        RGB rgbFailCovered = lookup.getAnnotationPreference(CoverageAnnotation.Kind.FAILED.getId()).getColorPreferenceValue();
        RGB rgbNotCovered = lookup.getAnnotationPreference(CoverageAnnotation.Kind.NOT_COVERED.getId()).getColorPreferenceValue();
        RGB rgbTestPassedCovered = lookup.getAnnotationPreference(CoverageAnnotation.Kind.TEST_PASSED_COVERED.getId()).getColorPreferenceValue();
        RGB rgbTestFailedCovered = lookup.getAnnotationPreference(CoverageAnnotation.Kind.TEST_FAILED_COVERED.getId()).getColorPreferenceValue();
        this.colorCovered = rgbCovered == null ? this.getDefaultBackground() : EditorsUI.getSharedTextColors().getColor(rgbCovered);
        this.colorFailCovered = rgbCovered == null ? this.getDefaultBackground() : EditorsUI.getSharedTextColors().getColor(rgbFailCovered);
        this.colorNotCovered = rgbNotCovered == null ? this.getDefaultBackground() : EditorsUI.getSharedTextColors().getColor(rgbNotCovered);
        this.colorCoveredByPassedTest = rgbTestPassedCovered == null ? this.getDefaultBackground() : EditorsUI.getSharedTextColors().getColor(rgbTestPassedCovered);
        this.colorCoveredByFailedTest = rgbTestFailedCovered == null ? this.getDefaultBackground() : EditorsUI.getSharedTextColors().getColor(rgbTestFailedCovered);
        this.setTextInset(4);
        this.setHover(new CoverageAnnotationRulerHover(this));
    }

    public void columnCreated() {
    }

    public void columnRemoved() {
    }

    public RulerColumnDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public ITextEditor getEditor() {
        return this.fEditor;
    }

    public void setDescriptor(RulerColumnDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public void setEditor(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void setModel(IAnnotationModel model) {
        IAnnotationModel currentModel = this.getModel();
        if (currentModel != null) {
            currentModel.removeAnnotationModelListener(this.annotationListener);
        }
        super.setModel(model);
        if (model != null) {
            model.addAnnotationModelListener(this.annotationListener);
        }
    }

    ILineCoverageModel.Entry getAnnotation(int lineNumber) {
        return this.coverageAnnotationModel == null || this.coverageAnnotationModel.getLineCoverageModel() == null ? null : this.coverageAnnotationModel.getLineCoverageModel().getForLine(lineNumber);
    }

    Set<TestCaseInfo> getPerTestInfo(ILineCoverageModel.Entry annotation) {
        CloverDatabase db = this.coverageAnnotationModel == null ? null : this.coverageAnnotationModel.cloverDatabaseForEditorInput();
        FullElementInfo info = this.getInfo(annotation);
        return db == null || info == null ? Collections.emptySet() : db.getTestHits((CoverageDataRange)info);
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        ILineCoverageModel.Entry annotation = this.getAnnotation(modelLine);
        if (this.computeFilter(modelLine)) {
            Color emptyColor = super.computeBackground(modelLine);
            gc.setBackground(emptyColor);
            gc.fillRectangle(0, linePixel, this.getWidth(), lineHeight);
            return;
        }
        String text = this.computeText(annotation);
        Color leftBar = this.computeOptimisticBackground(modelLine);
        Color rightBar = this.computePessimisticBackground(modelLine);
        Color barCode = this.computeRightTestStrip(annotation, modelLine);
        if (leftBar.equals((Object)rightBar)) {
            gc.setBackground(leftBar);
            gc.fillRectangle(0, linePixel, this.getWidth(), lineHeight);
        } else {
            gc.setBackground(leftBar);
            gc.fillRectangle(0, linePixel, this.getWidth() / 2, lineHeight);
            gc.setBackground(rightBar);
            gc.fillRectangle(this.getWidth() / 2, linePixel, this.getWidth(), lineHeight);
        }
        if (barCode != null) {
            gc.setBackground(barCode);
            gc.fillRectangle(this.getWidth() - 4, linePixel, this.getWidth(), lineHeight);
        }
        if (text != null) {
            int textWidth = gc.stringExtent((String)text).x;
            int minWidth = textWidth + 2 * this.getTextInset();
            if (this.getWidth() < minWidth) {
                this.setWidth(minWidth);
            }
            gc.setForeground(this.computeForeground(modelLine));
            gc.drawString(text, this.getWidth() - (textWidth + this.getTextInset()), linePixel, true);
        }
    }

    protected String computeText(ILineCoverageModel.Entry annotation) {
        FullElementInfo info = this.getInfo(annotation);
        return info == null ? null : String.valueOf(info.getHitCount());
    }

    FullElementInfo getInfo(ILineCoverageModel.Entry annotation) {
        return annotation == null ? null : annotation.getElementInfo();
    }

    protected Color computeForeground(int line) {
        return Display.getDefault().getSystemColor(2);
    }

    protected boolean computeFilter(int line) {
        ILineCoverageModel lineCoverageModel;
        if (this.coverageAnnotationModel != null && (lineCoverageModel = this.coverageAnnotationModel.getLineCoverageModel()) != null) {
            return lineCoverageModel.isFilteredInLine(line);
        }
        return false;
    }

    protected Color computeOptimisticBackground(int line) {
        ILineCoverageModel lineCoverageModel;
        ILineCoverageModel iLineCoverageModel = lineCoverageModel = this.coverageAnnotationModel != null ? this.coverageAnnotationModel.getLineCoverageModel() : null;
        if (lineCoverageModel == null || lineCoverageModel.getForLine(line) == null) {
            return super.computeBackground(line);
        }
        boolean hasHitsInLine = lineCoverageModel.hasHitsInLine(line);
        boolean hasPassedHitsInLine = lineCoverageModel.hasPassedHitsInLine(line);
        boolean hasFailedHitsInLine = lineCoverageModel.hasFailedHitsInLine(line);
        if (hasPassedHitsInLine || !hasFailedHitsInLine && hasHitsInLine) {
            return this.colorCovered;
        }
        if (hasHitsInLine) {
            return this.colorFailCovered;
        }
        return this.colorNotCovered;
    }

    protected Color computePessimisticBackground(int line) {
        ILineCoverageModel lineCoverageModel;
        ILineCoverageModel iLineCoverageModel = lineCoverageModel = this.coverageAnnotationModel != null ? this.coverageAnnotationModel.getLineCoverageModel() : null;
        if (lineCoverageModel == null || lineCoverageModel.getForLine(line) == null) {
            return super.computeBackground(line);
        }
        boolean hasMissesInLine = lineCoverageModel.hasMissesInLine(line);
        boolean hasFailedHitsInLine = lineCoverageModel.hasFailedHitsInLine(line);
        if (hasMissesInLine) {
            return this.colorNotCovered;
        }
        if (hasFailedHitsInLine) {
            return this.colorFailCovered;
        }
        return this.colorCovered;
    }

    protected Color computeRightTestStrip(ILineCoverageModel.Entry annotation, int line) {
        if (this.getPerTestInfo(annotation).isEmpty()) {
            return null;
        }
        if (this.coverageAnnotationModel != null) {
            ILineCoverageModel lineCoverageModel = this.coverageAnnotationModel.getLineCoverageModel();
            if (lineCoverageModel != null && lineCoverageModel.hasFailedHitsInLine(line)) {
                return this.colorCoveredByFailedTest;
            }
            return this.colorCoveredByPassedTest;
        }
        return null;
    }

    public void dispose() {
        this.colorCovered.dispose();
        this.colorFailCovered.dispose();
        this.colorCoveredByPassedTest.dispose();
        this.colorCoveredByFailedTest.dispose();
        this.colorNotCovered.dispose();
        super.dispose();
    }
}

