/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.testopt;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.eclipse.core.projects.CloverProject;
import com.atlassian.clover.eclipse.testopt.IMemberAdapter;
import com.atlassian.clover.eclipse.testopt.TestOptimizationPlugin;
import com.atlassian.clover.eclipse.testopt.TestOptimizationPluginMessages;
import com.atlassian.clover.optimization.LocalSnapshotOptimizer;
import com.atlassian.clover.optimization.Messages;
import com.atlassian.clover.optimization.OptimizationSession;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.registry.Clover2Registry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;

public class CloveredOptimizedLauncherDelegate
extends JUnitLaunchConfigurationDelegate {
    protected IMember[] evaluateTests(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IMember[] allTests = super.evaluateTests(configuration, monitor);
        IJavaProject project = this.getJavaProject(configuration);
        OptimizationSession[] sessionHolder = new OptimizationSession[]{null};
        if (project == null) {
            TestOptimizationPlugin.logWarning("Cannot optimize: unable to retrieve IJavaProject for launch configuration " + configuration.getName());
            this.reportSavings(null);
            return allTests;
        }
        OptimizationOptions.Builder optionsTemplate = this.createOptionsTemplate(configuration);
        optionsTemplate.optimizableName("class");
        IMember[] result = this.optimize(allTests, project, optionsTemplate, sessionHolder);
        this.reportSavings(sessionHolder[0]);
        if (result.length != 0) {
            return result;
        }
        final String msg = TestOptimizationPluginMessages.getString("launch.optimized.notestsfound");
        final IPreferenceStore pluginPreferences = TestOptimizationPlugin.getDefault().getPreferenceStore();
        if (pluginPreferences.getBoolean("org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG")) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle mdwt = MessageDialogWithToggle.openInformation(null, (String)TestOptimizationPluginMessages.getPluginName(), (String)msg, (String)TestOptimizationPluginMessages.getString("launch.optimized.notestsfound.ask"), (boolean)true, null, null);
                    pluginPreferences.setValue("org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG", mdwt.getToggleState());
                }
            });
        }
        Status status = new Status(1, "org.openclover.eclipse.testopt", msg);
        throw new CoreException((IStatus)status);
    }

    private OptimizationOptions.Builder createOptionsTemplate(ILaunchConfiguration configuration) {
        boolean useDefaults;
        IPreferenceStore defaults = TestOptimizationPlugin.getDefault().getPreferenceStore();
        try {
            useDefaults = configuration.getAttribute("org.openclover.eclipse.testopt.USE_DEFAULT_SETTINGS", true);
        }
        catch (CoreException e) {
            useDefaults = true;
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute", e);
        }
        OptimizationOptions.Builder builder = new OptimizationOptions.Builder();
        try {
            boolean defaultDiscardStale = defaults.getBoolean("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS");
            boolean discardStale = useDefaults ? defaultDiscardStale : configuration.getAttribute("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS", defaultDiscardStale);
            int defaultDiscardAge = defaults.getInt("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE");
            int discardAge = discardStale ? (useDefaults ? defaultDiscardAge : configuration.getAttribute("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE", defaultDiscardAge)) : Integer.MAX_VALUE;
            builder.maxCompilesBeforeStaleSnapshot(discardAge);
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute", e);
        }
        try {
            boolean defaultMinimizeTests = defaults.getBoolean("org.openclover.eclipse.testopt.MINIMIZE_TESTS");
            boolean minimizeTests = useDefaults ? defaultMinimizeTests : configuration.getAttribute("org.openclover.eclipse.testopt.MINIMIZE_TESTS", defaultMinimizeTests);
            builder.minimize(minimizeTests);
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute", e);
        }
        try {
            String defaultReorderingStr = defaults.getString("org.openclover.eclipse.testopt.TEST_REORDERING");
            String reorderingStr = useDefaults ? defaultReorderingStr : configuration.getAttribute("org.openclover.eclipse.testopt.TEST_REORDERING", defaultReorderingStr);
            OptimizationOptions.TestSortOrder reordering = OptimizationOptions.TestSortOrder.valueOf((String)reorderingStr);
            builder.reorder(reordering);
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute", e);
        }
        catch (IllegalArgumentException e) {
            TestOptimizationPlugin.logWarning("Illegal test optimization parameter value", e);
        }
        return builder;
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        TestOptimizationPlugin.getDefault().setLastLaunchConfiguration(configuration);
        return super.getVMRunner(configuration, "run");
    }

    private IMember[] optimize(IMember[] allTests, IJavaProject project, OptimizationOptions.Builder optionsTemplate, OptimizationSession[] sessionHolder) {
        OptimizationOptions options;
        try {
            CloverProject cloverProject = CloverProject.getFor((IJavaProject)project);
            if (cloverProject == null) {
                TestOptimizationPlugin.logWarning("Cannot optimize: Clover not enabled for project " + project.getElementName());
                return allTests;
            }
            String initString = cloverProject.deriveInitString();
            options = optionsTemplate.initString(initString).snapshot(Snapshot.fileForInitString((String)initString)).build();
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Cannot optimize: unable to retrieve Clover settings for project " + project.getElementName(), e);
            return allTests;
        }
        TestOptimizationPlugin.logDebug("Optimizing with options: " + options.toString());
        Snapshot snapshot = this.loadSnapshot(options);
        if (snapshot == null) {
            return allTests;
        }
        Clover2Registry registry = this.loadRegistry(options);
        if (registry == null) {
            return allTests;
        }
        ArrayList<IMemberAdapter> input = new ArrayList<IMemberAdapter>(allTests.length);
        for (IMember test : allTests) {
            input.add(new IMemberAdapter(test));
        }
        LocalSnapshotOptimizer optimizer = new LocalSnapshotOptimizer(snapshot, registry, options);
        if (optimizer.canOptimize()) {
            sessionHolder[0] = new OptimizationSession(options);
            List optimized = optimizer.optimize(input, sessionHolder[0]);
            IMember[] optimizedMembers = new IMember[optimized.size()];
            int idx = 0;
            for (IMemberAdapter optimizable : optimized) {
                optimizedMembers[idx++] = optimizable.getIMember();
            }
            return optimizedMembers;
        }
        TestOptimizationPlugin.logWarning("Cannot optimize: " + optimizer.cannotOptimizeCause());
        return allTests;
    }

    private Snapshot loadSnapshot(OptimizationOptions options) {
        if (options.getSnapshotFile() == null) {
            TestOptimizationPlugin.logWarning("Cannot optimize: no snapshot file defined");
            return null;
        }
        Snapshot snapshot = Snapshot.loadFrom((File)options.getSnapshotFile());
        if (snapshot == null) {
            TestOptimizationPlugin.logInfo("Cannot optimize: Cannot load snapshot file from " + options.getSnapshotFile());
            return null;
        }
        if (snapshot.isTooStale(options.getMaxCompilesBeforeStaleSnapshot())) {
            TestOptimizationPlugin.logInfo("Cannot optimize: Maximum count of compilations before snapshot stale exceeded (" + options.getMaxCompilesBeforeStaleSnapshot() + ")");
            snapshot.delete();
            return null;
        }
        return snapshot;
    }

    private Clover2Registry loadRegistry(OptimizationOptions options) {
        if (options.getInitString() == null) {
            TestOptimizationPlugin.logWarning("Cannot optimize: initstring not defined");
            return null;
        }
        try {
            Clover2Registry registry = Clover2Registry.fromFile((File)new File(options.getInitString()));
            if (registry == null) {
                TestOptimizationPlugin.logWarning("Cannot optimize: cannot load registry from " + options.getInitString());
            }
            return registry;
        }
        catch (CloverException e) {
            TestOptimizationPlugin.logWarning(Messages.noOptimizationBecauseOfException((Exception)((Object)e)));
            return null;
        }
    }

    private void reportSavings(OptimizationSession session) {
        TestOptimizationPlugin.getDefault().notifyOptimizationSessionListener(session);
    }
}

