/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.runtime;

import com.atlassian.clover.eclipse.runtime.CloverPlugin;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

public class VariableInitialiser
extends ClasspathVariableInitializer {
    private static final String RUNTIME_JAR_PATH = "/clover-runtime.jar";

    public void initialize(String variable) {
        Bundle bundle = CloverPlugin.getInstance().getBundle();
        if (bundle == null) {
            this.unsetVariable(variable);
        } else {
            URL root = bundle.getResource(RUNTIME_JAR_PATH);
            try {
                URL local = FileLocator.toFileURL((URL)root);
                if (local != null) {
                    String path = new File(local.getPath()).getAbsolutePath();
                    JavaCore.setClasspathVariable((String)variable, (IPath)Path.fromOSString((String)path), null);
                    CloverPlugin.getInstance();
                    CloverPlugin.log(1, "Setting classpath variable \"" + variable + "\" to \"" + path + "\"", null);
                } else {
                    CloverPlugin.getInstance();
                    CloverPlugin.log(4, "Unable to set \"" + variable + "\" classpath variable, unable to locate runtime jar", null);
                }
            }
            catch (Throwable e) {
                CloverPlugin.getInstance();
                CloverPlugin.log(4, "Unable to set \"" + variable + "\" classpath variable", e);
                this.unsetVariable(variable);
            }
        }
    }

    private void unsetVariable(String variable) {
        CloverPlugin.getInstance();
        CloverPlugin.log(1, "Unsetting \"" + variable + "\" classpath variable", null);
        JavaCore.removeClasspathVariable((String)variable, null);
    }
}

