/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.testopt;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.eclipse.core.projects.CloverProject;
import com.atlassian.clover.eclipse.testopt.TestOptimizationPlugin;
import com.atlassian.clover.optimization.Snapshot;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestRunSession;

public class OptimizedTestRunListener
extends TestRunListener {
    public void sessionFinished(ITestRunSession session) {
        if (!(session instanceof TestRunSession)) {
            TestOptimizationPlugin.logInfo("Expected TestRunSession instance, received " + session.getClass().getName());
            return;
        }
        TestRunSession trs = (TestRunSession)session;
        if ("clover.optimized".equals(trs.getLaunch().getLaunchMode())) {
            CloverDatabase db;
            CloverProject cloverProject;
            IJavaProject project = trs.getLaunchedProject();
            if (project == null) {
                TestOptimizationPlugin.logInfo("Cannot retrieve project from TestRunSession " + trs.getTestRunName());
                return;
            }
            try {
                cloverProject = CloverProject.getFor((IJavaProject)project);
            }
            catch (CoreException e) {
                TestOptimizationPlugin.logInfo("Cannot retrieve CloverProject for project " + project.getElementName(), e);
                return;
            }
            if (cloverProject == null) {
                TestOptimizationPlugin.logInfo("Cannot retrieve CloverProject for project " + project.getElementName());
                return;
            }
            String initStr = cloverProject.deriveInitString();
            try {
                db = CloverDatabase.loadWithCoverage((String)initStr, (CoverageDataSpec)new CoverageDataSpec());
            }
            catch (CloverException e) {
                TestOptimizationPlugin.logInfo("Cannot load Clover database at " + initStr, e);
                return;
            }
            Snapshot snapshot = Snapshot.loadFor((String)initStr);
            if (snapshot != null) {
                snapshot.updateFor(db);
            } else {
                TestOptimizationPlugin.logInfo("Generating new snapshot for " + initStr);
                snapshot = Snapshot.generateFor((CloverDatabase)db);
            }
            try {
                snapshot.store();
            }
            catch (IOException e) {
                TestOptimizationPlugin.logWarning("Error storing generated snapshot", e);
            }
        }
    }
}

