/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.testopt.views.actions;

import com.atlassian.clover.eclipse.testopt.TestOptimizationPlugin;
import com.atlassian.clover.optimization.OptimizationSession;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class OptimizationSessionIcon
extends Composite {
    private Label label;
    private Label image;

    OptimizationSessionIcon(Composite parent, OptimizationSession session) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.image = new Label((Composite)this, 0);
        this.image.setImage(TestOptimizationPlugin.getDefault().getTestOptimizationIcon());
        this.label = new Label((Composite)this, 0);
        this.refresh(session);
    }

    public void refresh(OptimizationSession session) {
        String tooltipText;
        if (session == null) {
            this.label.setText("-/-");
            tooltipText = "No test optimization in effect";
        } else {
            this.label.setText("" + session.getOptimizedTestableCount() + "/" + session.getOriginalTestableCount());
            tooltipText = session.getPlainSummary();
        }
        this.label.setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 0x1000000).create());
        this.image.setToolTipText(tooltipText);
        this.label.setToolTipText(tooltipText);
        this.setToolTipText(tooltipText);
        this.update();
    }
}

