/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.testopt.actions;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.eclipse.testopt.TestOptimizationPlugin;
import com.atlassian.clover.eclipse.testopt.TestOptimizationPluginMessages;
import com.atlassian.clover.eclipse.testopt.actions.ActionUtils;
import java.util.ArrayList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.AbstractLaunchToolbarAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class OptimizedLaunchToolbarAction
extends AbstractLaunchToolbarAction {
    public OptimizedLaunchToolbarAction() {
        super("com.atlassian.clover.eclipse.core.launching.optimized.group");
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        super.selectionChanged(iAction, iSelection);
        iAction.setEnabled(this.getLastLaunch() != null || ActionUtils.isInCloverNature(iSelection));
    }

    protected ILaunchConfiguration[] getHistory() {
        Object[] historyArray = super.getHistory();
        ILaunchConfiguration lastConfiguration = TestOptimizationPlugin.getDefault().getLastLaunchConfiguration();
        if (lastConfiguration == null || historyArray.length > 0 && historyArray[0] == lastConfiguration) {
            return historyArray;
        }
        ArrayList history = Lists.newArrayList((Object[])historyArray);
        history.remove(lastConfiguration);
        history.add(0, lastConfiguration);
        return history.toArray(new ILaunchConfiguration[history.size()]);
    }

    protected ILaunchConfiguration getLastLaunch() {
        ILaunchConfiguration lastConfiguration = TestOptimizationPlugin.getDefault().getLastLaunchConfiguration();
        return lastConfiguration != null ? lastConfiguration : super.getLastLaunch();
    }

    public void run(IAction action) {
        ILaunchConfiguration configuration = this.getLastLaunch();
        if (configuration == null) {
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection(), (String)this.getLaunchGroupIdentifier());
        } else {
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)this.getMode());
        }
    }

    protected void updateTooltip() {
        ILaunchConfiguration configuration = this.getLastLaunch();
        String message = configuration == null ? TestOptimizationPluginMessages.getString("launch.optimized.toolbar.label") : TestOptimizationPluginMessages.getFormattedString("launch.optimized.toolbar.tooltip", configuration.getName());
        this.getAction().setToolTipText(message);
    }
}

