/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.eclipse.testopt.actions;

import clover.com.google.common.collect.Maps;
import com.atlassian.clover.eclipse.core.ui.CloverPluginIcons;
import com.atlassian.clover.eclipse.testopt.actions.ActionUtils;
import java.util.Map;
import org.eclipse.debug.ui.actions.ContextualLaunchAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ContextualRunOptimizedAction
extends ContextualLaunchAction {
    private ResourceManager imageManager = new LocalResourceManager(JFaceResources.getResources());
    private Map images = Maps.newHashMap();

    public ContextualRunOptimizedAction() {
        super("clover.optimized");
        this.addImageForShortcutCommand("com.atlassian.clover.eclipse.core.launching.LocalJavaApplicationShortcut.clover.optimized", "org.eclipse.jdt.debug.ui", "icons/full/etool16/java_app.gif");
        this.addImageForShortcutCommand("com.atlassian.clover.eclipse.core.launching.LocalJavaAppletShortcut.clover.optimized", "org.eclipse.jdt.debug.ui", "icons/full/etool16/java_applet.gif");
        this.addImageForShortcutCommand("com.atlassian.clover.eclipse.core.launching.WorkbenchPDEShortcut.clover.optimized", "org.eclipse.pde.ui", "icons/obj16/eclipse.gif");
        this.addImageForShortcutCommand("com.atlassian.clover.eclipse.core.launching.JUnitShortcut.clover.optimized", "org.eclipse.jdt.junit", "icons/full/obj16/julaunch.gif");
        this.addImageForShortcutCommand("com.atlassian.clover.eclipse.core.launching.JUnitPDEShortcut.clover.optimized", "org.eclipse.pde.ui", "icons/obj16/julaunchpgn.gif");
    }

    private void addImageForShortcutCommand(String name, String bundleName, String resourcePath) {
        Image image = CloverPluginIcons.grabPluginImage((ResourceManager)this.imageManager, (String)bundleName, (String)resourcePath);
        if (image != null) {
            this.images.put(name, image);
        }
    }

    public void dispose() {
        super.dispose();
        this.imageManager.dispose();
        this.images.clear();
    }

    protected void fillMenu(Menu menu) {
        MenuItem[] items;
        super.fillMenu(menu);
        for (MenuItem item : items = menu.getItems()) {
            String commandId;
            if (!(item.getData() instanceof ActionContributionItem) || !this.images.containsKey(commandId = ((ActionContributionItem)item.getData()).getAction().getActionDefinitionId())) continue;
            item.setImage((Image)this.images.get(commandId));
        }
    }

    public void selectionChanged(IAction action, ISelection iSelection) {
        super.selectionChanged(action, iSelection);
        if (action.isEnabled()) {
            action.setEnabled(ActionUtils.isInCloverNature(iSelection));
        }
    }
}

