/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.reporters.html.ClassInfoStatsCalculator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openclover.util.Lists;

public class StatisticsClassInfoVisitor {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private final Map<BaseClassInfo, String> classes = new LinkedHashMap<BaseClassInfo, String>();
    private final ClassInfoStatsCalculator calculator;

    public StatisticsClassInfoVisitor(ClassInfoStatsCalculator calculator) {
        this.calculator = calculator;
    }

    public void visitClassInfo(BaseClassInfo classInfo) {
        if (!this.calculator.ignore(classInfo)) {
            int count = this.calculator.getScaledValue(classInfo);
            this.classes.put(classInfo, this.calculator.getFormattedValue(classInfo));
            if ((long)count <= this.min) {
                this.min = count;
            }
            if ((long)count >= this.max) {
                this.max = count;
            }
        }
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getRange() {
        return this.max - this.min;
    }

    public List<BaseClassInfo> getClasses() {
        return Lists.newArrayList(this.classes.keySet());
    }

    public boolean hasClassInfo(BaseClassInfo info) {
        return this.classes.containsKey(info);
    }

    public ClassInfoStatsCalculator getCalculator() {
        return this.calculator;
    }

    public static StatisticsClassInfoVisitor visit(List<BaseClassInfo> classes, ClassInfoStatsCalculator statsCalculator) {
        StatisticsClassInfoVisitor visitor = new StatisticsClassInfoVisitor(statsCalculator);
        for (BaseClassInfo cls : classes) {
            visitor.visitClassInfo(cls);
        }
        return visitor;
    }
}

