/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.api.registry.ProjectInfo;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.FileMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsNode;
import com.atlassian.clover.registry.metrics.PackageMetrics;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;

public class FullPackageInfo
extends BasePackageInfo
implements HasMetricsNode,
CoverageDataReceptor,
PackageInfo {
    private int dataIndex;
    private int dataLength;
    private Comparator orderby;
    private CoverageDataProvider data;

    public FullPackageInfo(FullProjectInfo containingProject, String pkg, int dataIndex) {
        super(containingProject, pkg);
        this.dataIndex = dataIndex;
    }

    public static FullPackageInfo createEmptyFromTemplate(FullPackageInfo info) {
        return new FullPackageInfo(null, info.getName(), 0);
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        for (FileInfo file : this.files.values()) {
            FullFileInfo fullFileInfo = (FullFileInfo)file;
            fullFileInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public int getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataIndex(int index) {
        this.dataIndex = index;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    @Override
    public String getChildType() {
        return "class";
    }

    @Override
    public int getNumChildren() {
        if (this.classes == null) {
            this.gatherClassesFromPackage();
        }
        return this.classes.size();
    }

    @Override
    public HasMetricsNode getChild(int i) {
        if (this.classes == null) {
            this.gatherClassesFromPackage();
        }
        return (HasMetricsNode)this.classes.get(i);
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        if (this.classes == null) {
            this.gatherClassesFromPackage();
        }
        return this.classes.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.classes = null;
        for (FileInfo fileInfo : this.files.values()) {
            FullFileInfo fullFileInfo = (FullFileInfo)fileInfo;
            fullFileInfo.setComparator(cmp);
        }
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getContainingProject().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingProject().getContextFilter();
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    @Override
    protected void gatherClassesFromPackage() {
        super.gatherClassesFromPackage();
        if (this.orderby != null) {
            Collections.sort(this.classes, this.orderby);
        }
    }

    private PackageMetrics calcMetrics(boolean filter) {
        PackageMetrics packageMetrics = new PackageMetrics(this);
        int numFiles = 0;
        for (FileInfo fileInfo : this.files.values()) {
            FullFileInfo fullFileInfo = (FullFileInfo)fileInfo;
            if (!filter) {
                packageMetrics.add((FileMetrics)fullFileInfo.getRawMetrics());
            } else {
                packageMetrics.add((FileMetrics)fullFileInfo.getMetrics());
            }
            ++numFiles;
        }
        packageMetrics.setNumFiles(numFiles);
        return packageMetrics;
    }

    public FullPackageInfo copy(FullProjectInfo proj, HasMetricsFilter filter) {
        FullPackageInfo pkg = new FullPackageInfo(proj, this.name, this.dataIndex);
        pkg.setDataProvider(this.getDataProvider());
        for (FileInfo fileInfo : this.files.values()) {
            FullFileInfo info;
            FullFileInfo fullFileInfo = (FullFileInfo)fileInfo;
            if (!filter.accept(fullFileInfo) || (info = fullFileInfo.copy(pkg, filter)).isEmpty()) continue;
            pkg.addFile(info);
        }
        pkg.setDataLength(this.getDataLength());
        return pkg;
    }

    public String toString() {
        return "FullPackageInfo{name='" + this.name + '\'' + ", defaultPkg=" + this.defaultPkg + ", path='" + this.path + '\'' + '}';
    }

    @Override
    public boolean isDescendantOf(PackageInfo other) {
        final AtomicReference otherContainingProject = new AtomicReference();
        other.getParent().visit(new EntityVisitor(){

            @Override
            public void visitProject(ProjectInfo parentProject) {
                otherContainingProject.set(parentProject);
            }
        });
        return this.containingProject == otherContainingProject.get() && this != other && (other.isDefault() || this.getName().indexOf(String.valueOf(other.getName()) + ".") == 0);
    }
}

