/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.api.registry.Annotation;
import com.atlassian.clover.api.registry.AnnotationValue;
import com.atlassian.clover.registry.entities.AnnotationImpl;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.StringifiedAnnotationValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openclover.util.Sets;

public class ExpectedExceptionMiner {
    private static final Pattern XDOCLET_NVP_PATTERN = Pattern.compile("\\s*(\\S+)\\s*=\\s*\"([^\"]*)\"");
    private static final Pattern WS_SPLIT_PATTERN = Pattern.compile("\\s+");
    private static final Pattern DOT_SPLIT_PATTERN = Pattern.compile("\\.");

    public static String[] extractExpectedExceptionsFor(MethodSignature sig, boolean checkTags) {
        TreeSet<String> exceptionNames = Sets.newTreeSet();
        ExpectedExceptionMiner.expectedExceptionsFromAnnotations(sig, exceptionNames);
        if (exceptionNames.size() == 0 && checkTags) {
            ExpectedExceptionMiner.expectedExceptionsFromJavadoc(sig, exceptionNames);
        }
        return exceptionNames.toArray(new String[0]);
    }

    private static void expectedExceptionsFromJavadoc(MethodSignature sig, SortedSet<String> exceptionNames) {
        Map<String, List<String>> tags = sig.getTags();
        if (tags != null && tags.size() > 0) {
            ExpectedExceptionMiner.extractExpectedExceptions("testng.test", "expectedExceptions", exceptionNames, tags);
            ExpectedExceptionMiner.extractExpectedExceptions("testng.expected-exceptions", "value", exceptionNames, tags);
        }
    }

    private static void extractExpectedExceptions(String tagName, String attributeName, SortedSet<String> exceptionNames, Map<String, List<String>> tags) {
        List<String> testTagValues = tags.get(tagName);
        if (testTagValues != null) {
            for (String testTagValue : testTagValues) {
                ExpectedExceptionMiner.processTagValue(attributeName, exceptionNames, testTagValue);
            }
        }
    }

    private static void processTagValue(String attributeName, SortedSet<String> exceptionNames, String testTagValue) {
        Matcher testTagValueMatcher = XDOCLET_NVP_PATTERN.matcher(testTagValue);
        if (testTagValueMatcher.find()) {
            String attrName = testTagValueMatcher.group(1);
            String attrValue = testTagValueMatcher.group(2);
            if (attributeName.equals(attrName)) {
                ExpectedExceptionMiner.processExceptionNames(exceptionNames, attrValue);
            }
        }
    }

    private static void processExceptionNames(SortedSet<String> exceptionNames, String attrValue) {
        String[] classNames;
        String[] stringArray = classNames = WS_SPLIT_PATTERN.split(attrValue);
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            if (ExpectedExceptionMiner.looksLikeFQClassName(className)) {
                exceptionNames.add(className);
            }
            ++n2;
        }
    }

    private static boolean looksLikeFQClassName(String className) {
        String[] parts;
        if (className == null) {
            return false;
        }
        String[] stringArray = parts = DOT_SPLIT_PATTERN.split(className);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!ExpectedExceptionMiner.isIdent(part)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void expectedExceptionsFromAnnotations(MethodSignature sig, SortedSet<String> exceptionNames) {
        Collection<Annotation> specificationAnnotation;
        Collection<Annotation> expectedExceptionsAnnotation;
        AnnotationValue expectedAttrValue = null;
        Collection<Annotation> testAnnotations = ExpectedExceptionMiner.findTestAnnotation(sig);
        if (testAnnotations != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractExpectedAttrValue(sig, testAnnotations);
        }
        if (expectedAttrValue == null && (expectedExceptionsAnnotation = ExpectedExceptionMiner.findTestNGExpectedExceptionsAnnotation(sig)) != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractValueAttrValue(sig, expectedExceptionsAnnotation);
        }
        if (expectedAttrValue == null && (expectedExceptionsAnnotation = ExpectedExceptionMiner.findSpringExpectedExceptionsAnnotation(sig)) != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractValueAttrValue(sig, expectedExceptionsAnnotation);
        }
        if (expectedAttrValue == null && (specificationAnnotation = ExpectedExceptionMiner.findSpecificationAnnotation(sig)) != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractExpectedAttrValue(sig, specificationAnnotation);
        }
        if (expectedAttrValue != null) {
            ExpectedExceptionMiner.extractExpectedExceptions(exceptionNames, expectedAttrValue);
        }
    }

    private static Collection<Annotation> findTestAnnotation(MethodSignature sig) {
        Collection<Annotation> testAnnotation = sig.getModifiers().getAnnotation("org.junit.Test");
        testAnnotation = !testAnnotation.isEmpty() ? testAnnotation : sig.getModifiers().getAnnotation("org.testng.annotations.Test");
        testAnnotation = !testAnnotation.isEmpty() ? testAnnotation : sig.getModifiers().getAnnotation("Test");
        return testAnnotation;
    }

    private static Collection<Annotation> findTestNGExpectedExceptionsAnnotation(MethodSignature sig) {
        return ExpectedExceptionMiner.findAnnotationValue(sig, "ExpectedExceptions", "org.testng.annotations.ExpectedExceptions");
    }

    private static Collection<Annotation> findSpringExpectedExceptionsAnnotation(MethodSignature sig) {
        return ExpectedExceptionMiner.findAnnotationValue(sig, "ExpectedException", "org.springframework.test.annotation.ExpectedException");
    }

    private static Collection<Annotation> findAnnotationValue(MethodSignature sig, String expectedAnnoName, String fqExpectedAnnoName) {
        Collection<Annotation> expectedAnnotation = sig.getModifiers().getAnnotation(expectedAnnoName);
        return !expectedAnnotation.isEmpty() ? expectedAnnotation : sig.getModifiers().getAnnotation(fqExpectedAnnoName);
    }

    private static Collection<Annotation> findSpecificationAnnotation(MethodSignature sig) {
        return ExpectedExceptionMiner.findAnnotationValue(sig, "com.googlecode.instinct.marker.annotate.Specification", "Specification");
    }

    private static AnnotationValue extractExpectedAttrValue(MethodSignature sig, Collection<Annotation> annotationCollection) {
        for (Annotation annotation : annotationCollection) {
            AnnotationValue value = ExpectedExceptionMiner.extractExpectedAttrValue(sig, annotation);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static AnnotationValue extractExpectedAttrValue(MethodSignature sig, Annotation testAnnotation) {
        AnnotationValue value = testAnnotation.getAttribute("expectedExceptions");
        value = value != null ? value : testAnnotation.getAttribute("expected");
        return value != null ? value : testAnnotation.getAttribute("expectedException");
    }

    private static AnnotationValue extractValueAttrValue(MethodSignature sig, Collection<Annotation> annotationCollection) {
        for (Annotation annotation : annotationCollection) {
            AnnotationValue value = annotation.getAttribute("value");
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static AnnotationValue extractValueAttrValue(MethodSignature sig, AnnotationImpl expectedExceptionsAnnotation) {
        return expectedExceptionsAnnotation.getAttribute("value");
    }

    private static void extractExpectedExceptions(SortedSet<String> exceptionNames, AnnotationValue expectedAttrValue) {
        List<? extends AnnotationValue> exceptionsNameValues = expectedAttrValue.toList();
        for (AnnotationValue annotationValue : exceptionsNameValues) {
            StringifiedAnnotationValue classNameValue;
            String className;
            if (!(annotationValue instanceof StringifiedAnnotationValue) || (className = ExpectedExceptionMiner.stripClassNameFromDotClassExpression(classNameValue = (StringifiedAnnotationValue)annotationValue)) == null) continue;
            exceptionNames.add(className);
        }
    }

    private static String stripClassNameFromDotClassExpression(StringifiedAnnotationValue classNameValue) {
        String[] parts;
        String[] stringArray = parts = DOT_SPLIT_PATTERN.split(classNameValue.getValue());
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!ExpectedExceptionMiner.isIdent(part)) {
                return null;
            }
            ++n2;
        }
        return classNameValue.getValue().endsWith(".class") ? classNameValue.getValue().substring(0, classNameValue.getValue().lastIndexOf(".class")) : classNameValue.getValue();
    }

    private static boolean isIdent(String ident) {
        if (ident == null || ident.length() == 0 || !Character.isJavaIdentifierStart(ident.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < ident.length()) {
            if (!Character.isJavaIdentifierPart(ident.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

