/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.antlr.CharScanner;
import clover.antlr.CommonHiddenStreamToken;
import clover.antlr.Token;
import clover.antlr.TokenStreamException;
import clover.antlr.TokenStreamHiddenTokenFilter;
import com.atlassian.clover.Contract;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.instrumentation.InstrumentationSession;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.FileStructureInfo;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public class CloverTokenStreamFilter
extends TokenStreamHiddenTokenFilter {
    public static final String MARKER_PREFIX = "/* $$ This file has been instrumented by Clover ";
    public static final String MARKER = "/* $$ This file has been instrumented by Clover 4.5.2#20240131180750 $$ */";
    private static final String DIRECTIVE_PREFIX = "CLOVER:";
    private static final int DIRECTIVE_LENGTH = "CLOVER:".length();
    private static final String DIRECTIVE_ON = "ON";
    private static final String DIRECTIVE_OFF = "OFF";
    private static final String DIRECTIVE_FLUSH = "FLUSH";
    private static final String DIRECTIVE_CLASS = "USECLASS";
    private static final String DIRECTIVE_LAMBDA_VOID = "VOID";
    private CloverToken last = null;
    private CloverToken first = null;
    private String filePath;

    public static void guardAgainstDoubleInstrumentation(File orig, BufferedReader bin) throws IOException, CloverException {
        String maybeMarker;
        Contract.check(bin.markSupported(), "Must use a markSupporting Reader when instrumenting");
        int markerLength = MARKER_PREFIX.length();
        bin.mark(markerLength);
        char[] chars = new char[markerLength];
        int charCount = bin.read(chars, 0, markerLength);
        if (charCount == markerLength && (maybeMarker = new String(chars)).equals(MARKER_PREFIX)) {
            throw new CloverException("Double instrumentation detected: " + orig.getAbsolutePath() + " appears to have already been instrumented by Clover.");
        }
        bin.reset();
    }

    public CloverTokenStreamFilter(String filePath, CharScanner input) {
        super(input);
        this.filePath = filePath;
        input.setTokenObjectClass(CloverToken.class.getName());
        this.hide(112);
        this.hide(113);
        this.hide(114);
    }

    private int countNewLines(String s) {
        int res = 0;
        int i = 0;
        while (i < s.length()) {
            if (i < s.length() - 1 && s.charAt(i) == '\r' && s.charAt(i + 1) == '\n') {
                ++res;
                ++i;
            } else if (s.charAt(i) == '\r' || s.charAt(i) == '\n') {
                ++res;
            }
            ++i;
        }
        return res;
    }

    private void scanForDirectives(Token tok, InstrumentationState state) {
        String text = tok.getText();
        if (text == null) {
            return;
        }
        int startDirective = text.indexOf(DIRECTIVE_PREFIX);
        int curLine = tok.getLine();
        while (startDirective >= 0) {
            String rest = this.processDirective(state, text, startDirective, curLine += this.countNewLines(text.substring(0, startDirective)));
            startDirective = rest.indexOf(DIRECTIVE_PREFIX);
            text = rest;
        }
    }

    @NotNull
    private String processDirective(InstrumentationState state, String text, int startDirective, int curLine) {
        String rest = text.substring(startDirective + DIRECTIVE_LENGTH);
        if (rest.startsWith(DIRECTIVE_ON)) {
            Logger.getInstance().debug(String.valueOf(this.filePath) + ":" + curLine + ": switching Clover instrumentation ON as per directive");
            state.setInstrEnabled(true);
            state.setInstrContext(state.getInstrContext().clear(0));
        } else if (rest.startsWith(DIRECTIVE_OFF)) {
            Logger.getInstance().debug(String.valueOf(this.filePath) + ":" + curLine + ": switching Clover instrumentation OFF as per directive");
            state.setInstrContext(state.getInstrContext().set(0));
            state.setInstrEnabled(false);
        } else if (rest.startsWith(DIRECTIVE_FLUSH)) {
            Logger.getInstance().debug(String.valueOf(this.filePath) + ":" + curLine + ": inserting flush as per directive");
            state.setNeedsFlush(true);
        } else if (rest.startsWith(DIRECTIVE_CLASS)) {
            Logger.getInstance().debug(String.valueOf(this.filePath) + ":" + curLine + ": using static inner holder class for instrumentation var as per directive");
            state.getCfg().setClassInstrStragegy(true);
        } else if (rest.startsWith(DIRECTIVE_LAMBDA_VOID)) {
            FullMethodInfo methodInfo = (FullMethodInfo)state.getSession().getCurrentMethod();
            if (methodInfo != null && methodInfo.isLambda()) {
                Logger.getInstance().debug(String.valueOf(this.filePath) + ":" + curLine + ": declaring lambda expression as void");
                methodInfo.setVoidReturnType(true);
            } else {
                Logger.getInstance().debug(String.valueOf(this.filePath) + ":" + curLine + ": could not declare lambda expression as void since there's no method stack");
            }
        } else {
            Logger.getInstance().warn(String.valueOf(this.filePath) + ":" + curLine + ": ignoring unknown Clover directive");
        }
        return rest;
    }

    @Override
    public Token nextToken() throws TokenStreamException {
        CloverToken next = (CloverToken)super.nextToken();
        next.setFilter(this);
        if (this.last != null) {
            while (this.last.getNext() != null) {
                this.last = this.last.getNext();
            }
            next.setPrev(this.last);
            this.last.setNext(next);
        } else {
            this.first = next;
        }
        this.last = next;
        return next;
    }

    public void instrument(FileStructureInfo structure, FullFileInfo fileInfo, InstrumentationSession session, JavaInstrumentationConfig cfg) {
        InstrumentationState state = new InstrumentationState(session, fileInfo, structure, cfg);
        this.scanHiddens(this.getInitialHiddenToken(), state);
        CloverToken curr = this.first;
        while (curr != null) {
            if (curr.hasEmitters()) {
                curr.initEmitters(state);
            }
            this.scanHiddens(curr.getHiddenAfter(), state);
            curr = curr.getNext();
        }
    }

    public void write(Writer outWriter) throws IOException {
        PrintWriter out = new PrintWriter(outWriter);
        out.print(MARKER);
        this.dumpHiddens(out, this.getInitialHiddenToken());
        CloverToken curr = this.first;
        while (curr != null) {
            curr.triggerPreEmitters(out);
            String str = curr.getText();
            if (str != null) {
                out.print(str);
            }
            curr.triggerPostEmitters(out);
            this.dumpHiddens(out, curr.getHiddenAfter());
            curr = curr.getNext();
        }
    }

    public boolean isEOLTerminated() {
        CloverToken beforeEOF;
        if (this.last != null && (beforeEOF = this.last.getPrev()) != null && beforeEOF.getHiddenAfter() != null) {
            CommonHiddenStreamToken curr;
            CommonHiddenStreamToken prev = curr = beforeEOF.getHiddenAfter();
            while (curr != null) {
                prev = curr;
                curr = curr.getHiddenAfter();
            }
            return prev.getText().endsWith("\n") || prev.getText().endsWith("\r");
        }
        return false;
    }

    private void dumpHiddens(PrintWriter out, CommonHiddenStreamToken tok) {
        while (tok != null) {
            out.print(tok.getText());
            tok = tok.getHiddenAfter();
        }
    }

    private void scanHiddens(CommonHiddenStreamToken tok, InstrumentationState state) {
        while (tok != null) {
            int type = tok.getType();
            if (113 == type || 114 == type) {
                this.scanForDirectives(tok, state);
            }
            tok = tok.getHiddenAfter();
        }
    }
}

