/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class UIUtils {
    public static void centerOnParent(Component aParent, Component aDialog) {
        int x = (aParent.getWidth() - aDialog.getWidth()) / 2 + aParent.getX();
        int y = (aParent.getHeight() - aDialog.getHeight()) / 2 + aParent.getY();
        aDialog.setLocation(Math.max(0, x), Math.max(0, y));
    }

    public static Component wrapWithFileChooser(final Component aParent, final JTextField aTextField, JButton dotDotDot, final int aFileSelectionMode) {
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)aTextField, "Center");
        pane.add((Component)dotDotDot, "East");
        dotDotDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(aTextField.getText());
                chooser.setFileSelectionMode(aFileSelectionMode);
                int choice = chooser.showDialog(aParent, "Select");
                if (choice == 0) {
                    aTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        return pane;
    }

    public static Component wrapWithFileChooser(Component aParent, JTextField aTextField, int aFileSelectionMode) {
        return UIUtils.wrapWithFileChooser(aParent, aTextField, new JButton("..."), aFileSelectionMode);
    }

    public static ImageIcon createImageIcon(String filename, String description) {
        String path = "/jfc_res/" + filename;
        return new ImageIcon(UIUtils.class.getResource(path), description);
    }

    public static Border createBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    }

    public static Border createDisabledBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, title, 0, 0, null, Color.gray), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    }

    public static Component createHorizontalLine() {
        JPanel p = new JPanel();
        p.add(Box.createHorizontalStrut(100));
        p.setBorder(BorderFactory.createEtchedBorder(1));
        return p;
    }

    public static JTextArea getHelpTextArea(String help, Color background, Font font) {
        JTextArea helpText = new JTextArea(help);
        helpText.setLineWrap(true);
        helpText.setWrapStyleWord(true);
        helpText.setBackground(background);
        helpText.setFont(font);
        helpText.setEditable(false);
        return helpText;
    }
}

