/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.ui;

import com.atlassian.clover.idea.util.ui.TreeSelectionHelper;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openclover.util.Sets;

public class TreeExpansionHelper
extends TreeSelectionHelper {
    private final Set<Object> expandedElements = Sets.newHashSet();

    public TreeExpansionHelper(JTree origTree) {
        super(origTree);
        TreePath rootPath = new TreePath(origTree.getModel().getRoot());
        Enumeration<TreePath> expanded = origTree.getExpandedDescendants(rootPath);
        while (expanded != null && expanded.hasMoreElements()) {
            TreePath treePath = expanded.nextElement();
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (element.getParent() == null) continue;
            this.expandedElements.add(TreeExpansionHelper.getWrapperObject(element.getUserObject()));
        }
    }

    @Override
    public void restore(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> children = root.depthFirstEnumeration();
        TreePath selectionPath = null;
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            Object wrappedObject = TreeExpansionHelper.getWrapperObject(child.getUserObject());
            if (this.expandedElements.contains(wrappedObject)) {
                TreePath tp = new TreePath(child.getPath());
                tree.expandPath(tp);
            }
            if (!this.selectedElement.equals(wrappedObject)) continue;
            selectionPath = new TreePath(child.getPath());
        }
        if (selectionPath != null) {
            tree.setSelectionPath(selectionPath);
        }
    }
}

